// Demonstracja klasy GCPtr. 
#include <iostream> 
#include <new> 
#include "gc.h" 
 
using namespace std; 
 
// Prosta klasa do testowania wskanika GCPtr z typami klasowymi.
class MyClass { 
  int a, b; 
public: 
  double val; 
 
  MyClass() { a = b = 0; } 
 
  MyClass(int x, int y) { 
    a = x; 
    b = y; 
    val = 0.0; 
  } 
 
  ~MyClass() { 
    cout << "Destruktor klasy MyClass(" << 
         a << ", " << b << ")\n"; 
  } 
 
  int sum() { 
    return a + b; 
  } 
 
  friend ostream &operator<<(ostream &strm, MyClass &obj); 
}; 
 
// Przeciony wyjciowy operator strumieniowy do wywietlenia klasy MyClass.
ostream &operator<<(ostream &strm, MyClass &obj) { 
  strm << "(" << obj.a << " " << obj.b << ")"; 
  return strm; 
} 
 
// Przeka do funkcji normalny wskanik.
void passPtr(int *p) { 
  cout << "Wewntrz funkcji passPtr(): " 
       << *p << endl; 
} 
 
// Przeka do funkcji wskanik GCPtr.
void passGCPtr(GCPtr<int, 0> p) { 
  cout << "Wewntrz funkcji passGCPtr(): "  
       << *p << endl; 
} 
 
int main() { 
 
  try { 
    // Zadeklaruj wskanik GCPtr na obiekt typu int.
    GCPtr<int> ip; 
 
    // Zaalokuj obiekt typu int i przypisz jej adres zmiennej ip.
    ip = new int(22); 
 
    // Wywietl jej warto.
    cout << "Warto w *ip: " << *ip << "\n\n"; 
 
    // Przeka zmienn ip do funkcji
    passGCPtr(ip); 
 
    // Utwrz zmienna ip2, ktra potem wyjdzie poza zasig.
    { 
      GCPtr<int> ip2 = ip; 
    } 
 
    int *p = ip; // przekonwertuj zmienn ip na wskanik typu int *
   
    passPtr(p); // przeka wskanik int * do funkcji passPtr()  
 
    *ip = 100; // Przypisz now warto pamici wskazywanej przez ip 
 
    // Teraz uyj niejawnej konwersji na wskanik int *
    passPtr(ip); 
    cout << endl; 
 
    // Utwrz wskanik GCPtr na tablic obiektw typu int
    GCPtr<int, 5> iap = new int[5]; 
 
    // Zainicjuj tablic dynamiczn.
    for(int i=0; i < 5; i++) 
      iap[i] = i; 
 
    // Wywietl zawarto tablicy.
    cout << "Zawarto tablicy iap wywietlona dziki indeksowaniu.\n"; 
    for(int i=0; i < 5; i++) 
      cout << iap[i] << " "; 
    cout << "\n\n"; 
 
    // Utwrz iterator GCiterator typu int.
    GCPtr<int>::GCiterator itr; 
 
    // Teraz uyj iteratora do dostpu do tablicy.
    cout << "Zawarto tablicy iap wywietlona za pomoc iteratora.\n"; 
    for(itr = iap.begin(); itr != iap.end(); itr++) 
      cout << *itr << " "; 
    cout << "\n\n"; 
 
    // Utwrz i porzu wiele obiektw
    for(int i=0; i < 10; i++) 
      ip = new int(i+10); 
 
    // Teraz, rcznie odzyskaj nieuywan pami w licie wskanikw GCPtr<int>.
    // Pamitaj, e nieuywane wskaniki typu GCPtr<int,5>
    // nie zostan zebrane przez to wywoanie.
    cout << "danie odzyskania pamici w licie wskanikw GCPtr<int>.\n"; 
    GCPtr<int>::collect(); 
 
    // Teraz uyj wskanika GCPtr z typem klasowym.
    GCPtr<MyClass> ob = new MyClass(10, 20); 
 
    // Wywietl wartoci przy uyciu operatora strumieniowego.
    cout << "ob wskazuje na " << *ob << endl; 
 
    // Zmie obiekt wskazywany przez wskanik ob.
    ob = new MyClass(11, 21); 
    cout << "ob wskazuje teraz na " << *ob << endl; 
 
    // Wywoaj metod przez wskanik GCPtr.
    cout << "Suma wynosi : " << ob->sum() << endl; 
 
    // Przypisz warto zmiennej skadowej przez wskanik GCPtr. 
    ob->val = 19.21; 
    cout << "ob->val: " << ob->val << "\n\n"; 
 
    cout << "Teraz praca ze wskanikami do obiektw klasowych.\n"; 
 
    // Zadeklaruj wskanik GCPtr na 5 elementow
    // tablic obiektw typu MyClass.
    GCPtr<MyClass, 5> v; 
 
    // Zaalokuj tablic.
    v = new MyClass[5];  
 
    // Pobierz iterator GCiterator typu MyClass.
    GCPtr<MyClass>::GCiterator mcItr; 
 
    // Zainicjuj tablic obiektw MyClass.
    for(int i=0; i<5; i++) { 
      v[i] = MyClass(i, 2*i); 
    } 
 
    // Wywietl zawarto tablicy obiektw MyClass uywajc indeksowania.
    cout << "Poruszenie si po tablicy przy uyciu indeksowania.\n"; 
    for(int i=0; i<5; i++) { 
      cout << v[i] << " "; 
    } 
    cout << "\n\n"; 
 
    // Wywietl zawarto tablicy obiektw MyClass uywajc iteratora.
    cout << "Poruszanie si po tablicy przy uyciu iteratora.\n"; 
    for(mcItr = v.begin(); mcItr != v.end(); mcItr++) { 
      cout << *mcItr << " "; 
    } 
    cout << "\n\n"; 
 
    // Inny sposb napisania poprzedniej ptli.
    cout << "Poruszanie si po tablicy przy uyciu ptli while.\n"; 
    mcItr = v.begin(); 
    while(mcItr != v.end()) { 
      cout << *mcItr << " "; 
      mcItr++; 
    } 
    cout << "\n\n"; 
 
    cout << "mcItr wskazuje na tablic o dugoci " 
         <<  mcItr.size() << " obiektw.\n"; 
 
    // Okrel liczb elementw midzy dwoma iteratorami.
    GCPtr<MyClass>::GCiterator mcItr2 = v.end()-2; 
    mcItr = v.begin(); 
    cout << "Rnica midzy mcItr2 i mcItr wynosi " 
         << mcItr2 - mcItr; 
    cout << "\n\n"; 
 
    // Mona take porusza si po tablicy w ten sposb.
    cout << "Dynamicznie oblicz dugo tablicy.\n"; 
    mcItr = v.begin(); 
    mcItr2 = v.end(); 
    for(int i=0; i < mcItr2 - mcItr; i++) { 
      cout << v[i] << " "; 
    } 
    cout << "\n\n"; 
 
  
    // Teraz wywietl zawarto tablicy od koca.
    cout << "Poruszanie si wstecz po tablicy.\n"; 
    for(mcItr = v.end()-1; mcItr >= v.begin(); mcItr--) 
      cout << *mcItr << " "; 
    cout << "\n\n"; 
 
    // Oczywicie mona uy "normalnego" wskanika do
    // poruszania si po tablicy.
    cout << "Poruszanie si po tablicy przy uyciu 'normalnego' wskanika\n"; 
    MyClass *ptr = v; 
    for(int i=0; i < 5; i++) 
      cout << *ptr++ << " "; 
    cout << "\n\n"; 
 
    // Mona si odwoywa do skadowych przez iterator GCiterator. 
    cout << "Dostp do skadowych klasy przez iterator.\n"; 
    for(mcItr = v.begin(); mcItr != v.end(); mcItr++) { 
      cout << mcItr->sum() << " "; 
    } 
    cout << "\n\n"; 
 
    // Mona normalnie zaalokowa i usun wskanik na obiekt GCPtr,
    // tak jak kady inny wskanik.
    cout << "Uycie wskanika na obiekt GCPtr.\n"; 
    GCPtr<int> *pp = new GCPtr<int>(); 
    *pp = new int(100); 
    cout << "Warto **pp wynosi: " << **pp; 
    cout << "\n\n"; 
 
    // Poniewa pp nie jest wskanikiem obsugiwanym przez
    // mechanizm odzyskiwania pamici musi by usunity rcznie.
    delete pp;  
  } catch(bad_alloc exc) { 
    // Prawdziwa aplikacja powinna sprbowa zwolni pami
    // funkcj collect gdy wystpi bd alokacji pamici.
    cout << "Bd alokacji pamici.\n"; 
  } 
 
  return 0; 
}

