// Rekurencyjny parser zstpujcy wyrae cakowitoliczbowych.
// 
#include <iostream> 
#include <cstring> 
#include <cstdlib> 
#include <cctype> 
#include "mccommon.h" 
 
using namespace std; 
 
// Tablica przegldowa sw kluczowych. 
// Sowa kluczowe musz by wpisane maymi literami. 
struct commands { 
  char command[20]; 
  token_ireps tok; 
} com_table[] = { 
  "if", IF,  
  "else", ELSE, 
  "for", FOR, 
  "do", DO, 
  "while", WHILE, 
  "char", CHAR, 
  "int", INT, 
  "return", RETURN, 
  "switch", SWITCH, 
  "break", BREAK, 
  "case", CASE, 
  "cout", COUT, 
  "cin", CIN, 
  "", END  // znacznik koca tabeli
}; 
 
// Struktura ta czy nazw funkcji bibliotecznej
// ze wskanikiem do tej funkcji.
struct intern_func_type { 
  char *f_name; // nazwa funkcji
  int (*p)();   // wskanik do funkcji 
} intern_func[] = { 
  "getchar", call_getchar, 
  "putchar", call_putchar, 
  "abs", call_abs, 
  "rand", call_rand, 
  "", 0  // zakocz list wartoci pust
}; 
 
// Punkt wejcia do parsera. 
void eval_exp(int &value) 
{ 
  get_token(); 
 
  if(!*token) { 
    throw InterpExc(NO_EXP); 
  } 
 
  if(*token == ';') { 
    value = 0; // puste wyraenie
    return; 
  } 
 
  eval_exp0(value); 
 
  putback(); // zwr ostatni przeczytany token do strumienia wejciowego
} 
 
// Przetwarzanie wyraenia przypisania. 
void eval_exp0(int &value) 
{ 
  // temp trzyma nazw zmiennej otrzymujcej przypisanie.
  char temp[MAX_ID_LEN+1];  
 
  tok_types temp_tok; 
 
  if(token_type == IDENTIFIER) { 
    if(is_var(token)) { // gdy zmienna, sprawd czy przypisanie
      strcpy(temp, token); 
      temp_tok = token_type; 
      get_token(); 
      if(*token == '=') { // jest przypisanie
        get_token(); 
        eval_exp0(value); // pobierz warto do przypisania
        assign_var(temp, value); // przypisz warto
        return; 
      } 
      else { // nie jest to przypisanie
        putback(); // przywr oryginalny token
        strcpy(token, temp); 
        token_type = temp_tok; 
      } 
    } 
  } 
  eval_exp1(value); 
} 
 
// Przetwarzanie operatorw relacyjnych. 
void eval_exp1(int &value) 
{ 
  int partial_value; 
  char op; 
  char relops[] = { 
    LT, LE, GT, GE, EQ, NE, 0 
  }; 
 
  eval_exp2(value); 
 
  op = *token; 
  if(strchr(relops, op)) { 
    get_token(); 
    eval_exp2(partial_value); 
 
    switch(op) { // wykonaj operacj relacyjn
      case LT: 
        value = value < partial_value; 
        break; 
      case LE: 
        value = value <= partial_value; 
        break; 
      case GT: 
        value = value > partial_value; 
        break; 
      case GE: 
        value = value >= partial_value; 
        break; 
      case EQ: 
        value = value == partial_value; 
        break; 
      case NE: 
        value = value != partial_value; 
        break; 
    } 
  } 
} 
 
// Dodaj lub odejmij dwa skadniki.
void eval_exp2(int &value) 
{ 
  char  op; 
  int partial_value; 
  char okops[] = { 
    '(', INC, DEC, '-', '+', 0 
  }; 
 
  eval_exp3(value); 
 
  while((op = *token) == '+' || op == '-') { 
    get_token(); 
 
    if(token_type == DELIMITER && 
       !strchr(okops, *token)) 
         throw InterpExc(SYNTAX); 
 
    eval_exp3(partial_value); 
 
    switch(op) { // dodaj lub odejmij
      case '-': 
        value = value - partial_value; 
        break; 
      case '+': 
        value = value + partial_value; 
        break; 
    } 
  } 
} 
 
// Pomn lub podziel dwa czynniki.
void eval_exp3(int &value) 
{ 
  char  op; 
  int partial_value, t; 
  char okops[] = { 
    '(', INC, DEC, '-', '+', 0 
  }; 
 
  eval_exp4(value); 
 
  while((op = *token) == '*' || op == '/' 
         || op == '%') { 
    get_token(); 
 
    if(token_type == DELIMITER && 
       !strchr(okops, *token)) 
         throw InterpExc(SYNTAX); 
 
    eval_exp4(partial_value); 
 
    switch(op) { // mnoenie, dzielenie lub modulo
      case '*': 
        value = value * partial_value; 
        break; 
      case '/': 
        if(partial_value == 0) 
          throw InterpExc(DIV_BY_ZERO);        
        value = (value) / partial_value; 
        break; 
      case '%': 
        t = (value) / partial_value; 
        value = value - (t * partial_value); 
        break; 
    } 
  } 
} 
 
// czy to jednoargumentowy +, -, ++ lub --
void eval_exp4(int &value) 
{ 
  char  op; 
  char temp; 
 
  op = '\0'; 
  if(*token == '+' || *token == '-' || 
     *token == INC || *token == DEC) 
  { 
    temp = *token; 
    op = *token; 
    get_token(); 
    if(temp == INC) 
      assign_var(token, find_var(token)+1); 
    if(temp == DEC) 
      assign_var(token, find_var(token)-1); 
  } 
 
  eval_exp5(value); 
  if(op == '-') value = -(value); 
} 
 
// Przetwarzanie wyraenia w nawiasie.
void eval_exp5(int &value) 
{ 
 
  if((*token == '(')) { 
    get_token(); 
 
    eval_exp0(value); // pobierz podwyraenie.
 
    if(*token != ')') 
      throw InterpExc(PAREN_EXPECTED); 
    get_token(); 
  } 
  else 
    atom(value); 
} 
 
// Znajd warto liczby, zmiennej lub funkcji.
void atom(int &value) 
{ 
  int i; 
  char temp[MAX_ID_LEN+1]; 
 
  switch(token_type) { 
    case IDENTIFIER: 
      i = internal_func(token); 
      if(i != -1) { 
        // Wywoaj funkcj z "biblioteki standardowej". 
        value = (*intern_func[i].p)(); 
      } 
      else if(find_func(token)) { 
        // Wywoaj funkcj stworzon przez programist.
        call(); 
        value = ret_value; 
      } 
      else { 
        value = find_var(token); // pobierz warto var
        strcpy(temp, token); // zapisz nazw zmiennej
 
        // Sprawd czy ++ lub --. 
        get_token(); 
        if(*token == INC || *token == DEC) { 
          if(*token == INC) 
            assign_var(temp, find_var(temp)+1); 
          else 
            assign_var(temp, find_var(temp)-1); 
        } else putback();          
      } 
 
      get_token(); 
      return; 
    case NUMBER: // staa numeryczna
      value = atoi(token); 
      get_token(); 
 
      return; 
    case DELIMITER: // czy staa znakowa
      if(*token == '\'') { 
        value = *prog; 
        prog++; 
        if(*prog!='\'') 
          throw InterpExc(QUOTE_EXPECTED); 
 
        prog++; 
        get_token(); 
 
        return ; 
      } 
      if(*token==')') return; // Przetwarzanie pustego wyraenia
      else throw InterpExc(SYNTAX);  // w przeciwnym razie bd skadniowy
    default: 
      throw InterpExc(SYNTAX); // bd skadniowy
  } 
} 
 
// Wywietl komunikat o bdzie. 
void sntx_err(error_msg error) 
{ 
  char *p, *temp; 
  int linecount = 0; 
 
  static char *e[]= { 
    "Bd skadniowy", 
    "Nie podano wyraenia", 
    "To nie jest zmienna", 
    "Powtarzajca si nazwa zmiennej", 
    "Powtarzajca si nazwa funkcji", 
    "Oczekiwano rednika", 
    "Bdne nawiasowanie", 
    "Niezdefiniowana funkcja", 
    "Wymagana specyfikacja typu", 
    "Return bez wywoania", 
    "Oczekiwano nawiasw", 
    "Oczekiwano sowa kluczowego while", 
    "Oczekiwano cudzysowu zamykajcego", 
    "Dzielenie przez zero", 
    "Oczekiwano { (instrukcje sterujce musz uywa blokw)", 
    "Oczekiwano dwykropka" 
  }; 
 
  // Wywietl bd i numer wiersza.
  cout << "\n" << e[error]; 
  p = p_buf; 
  while(p != prog) { // znajd numer wiersza z bdem
    p++; 
    if(*p == '\r') { 
      linecount++; 
    } 
  } 
  cout << " w wierszu " << linecount << endl; 
 
  temp = p; 
  while(p > p_buf && *p != '\n') p--; 
 
  // Wywietl niepoprawny wiersz. 
  while(p <= temp) 
    cout << *p++; 
 
  cout << endl; 
} 
 
// Pobierz token.
tok_types get_token() 
{ 
 
  char *temp; 
 
  token_type = UNDEFTT; tok = UNDEFTOK; 
 
  temp = token; 
  *temp = '\0'; 
 
  // Omi biae znaki.
  while(isspace(*prog) && *prog) ++prog; 
 
  // Omi znak nowego wiersza.
  while(*prog == '\r') { 
    ++prog; 
    ++prog; 
    // Znw omi biae znaki.
    while(isspace(*prog) && *prog) ++prog; 
  } 
 
  // Sprawd czy nie koniec programu.
  if(*prog == '\0') { 
    *token = '\0'; 
    tok = END; 
    return (token_type = DELIMITER); 
  } 
 
  // Sprawd czy ograniczniki bloku.
  if(strchr("{}", *prog)) {  
    *temp = *prog; 
    temp++; 
    *temp = '\0'; 
    prog++; 
    return (token_type = BLOCK); 
  } 
 
  // Szukaj komentarzy. 
  if(*prog == '/') 
    if(*(prog+1) == '*') { // czy komentarz /*
      prog += 2; 
      do { // znajd koniec komentarza
        while(*prog != '*') prog++; 
        prog++; 
      } while (*prog != '/'); 
      prog++; 
      return (token_type = DELIMITER); 
    } else if(*(prog+1) == '/') { // czy komentarz //
      prog += 2; 
      // Znajd koniec komentarza.
      while(*prog != '\r' && *prog != '\0') prog++; 
      if(*prog == '\r') prog +=2; 
      return (token_type = DELIMITER); 
    } 
 
  // Sprawd czy dwuznakowy operator.
  if(strchr("!<>=+-", *prog)) {  
    switch(*prog) { 
      case '=': 
        if(*(prog+1) == '=') { 
          prog++; prog++; 
          *temp = EQ; 
          temp++; *temp = EQ; temp++; 
          *temp = '\0'; 
        } 
        break; 
      case '!': 
        if(*(prog+1) == '=') { 
          prog++; prog++; 
          *temp = NE; 
          temp++; *temp = NE; temp++; 
          *temp = '\0'; 
        } 
        break; 
      case '<': 
        if(*(prog+1) == '=') { 
          prog++; prog++; 
          *temp = LE; temp++; *temp = LE; 
        } 
        else if(*(prog+1) == '<') { 
          prog++; prog++; 
          *temp = LS; temp++; *temp = LS; 
        } 
        else { 
          prog++; 
          *temp = LT; 
        } 
        temp++; 
        *temp = '\0'; 
        break; 
      case '>': 
        if(*(prog+1) == '=') { 
          prog++; prog++; 
          *temp = GE; temp++; *temp = GE; 
        } else if(*(prog+1) == '>') { 
          prog++; prog++; 
          *temp = RS; temp++; *temp = RS; 
        } 
        else { 
          prog++; 
          *temp = GT; 
        } 
        temp++; 
        *temp = '\0'; 
        break; 
      case '+': 
        if(*(prog+1) == '+') { 
          prog++; prog++; 
          *temp = INC; temp++; *temp = INC; 
          temp++; 
          *temp = '\0'; 
        } 
        break; 
      case '-': 
        if(*(prog+1) == '-') { 
          prog++; prog++; 
          *temp = DEC; temp++; *temp = DEC; 
          temp++; 
          *temp = '\0'; 
        } 
        break; 
    } 
 
    if(*token) return(token_type = DELIMITER); 
  } 
 
  // Kontrola innych separatorw.
  if(strchr("+-*^/%=;:(),'", *prog)) { 
    *temp = *prog; 
    prog++; 
    temp++; 
    *temp = '\0'; 
    return (token_type = DELIMITER); 
  } 
 
  // Wczytaj cig znakowy.
  if(*prog == '"') { 
    prog++; 
    while(*prog != '"' && *prog != '\r' && *prog) { 
      // Sprawd czy sekwencja kontrolna \n
      if(*prog == '\\') { 
        if(*(prog+1) == 'n') { 
          prog++; 
          *temp++ = '\n'; 
        } 
      } 
      else if((temp - token) < MAX_T_LEN)  
        *temp++ = *prog; 
 
      prog++; 
    } 
    if(*prog == '\r' || *prog == 0) 
      throw InterpExc(SYNTAX); 
    prog++; *temp = '\0'; 
    return (token_type = STRING); 
  } 
 
  // Wczytaj liczb cakowit.
  if(isdigit(*prog)) { 
    while(!isdelim(*prog)) { 
      if((temp - token) < MAX_ID_LEN)  
        *temp++ = *prog; 
      prog++; 
    } 
    *temp = '\0'; 
    return (token_type = NUMBER); 
  } 
 
  // Wczytaj identyfikator lub sowo kluczowe.
  if(isalpha(*prog)) { 
    while(!isdelim(*prog)) { 
      if((temp - token) < MAX_ID_LEN)  
        *temp++ = *prog; 
      prog++; 
    } 
    token_type = TEMP; 
  } 
 
  *temp = '\0'; 
 
  // Okrel, czy token jest sowem kluczowym czy identyfikatorem. 
  if(token_type == TEMP) { 
    tok = look_up(token); // przekszta do wewntrznej postaci.
    if(tok) token_type = KEYWORD; // jest sowem kluczowym
    else token_type = IDENTIFIER; 
  } 
 
  // Kontrola niezidentyfikowanego znaku w pliku.
  if(token_type == UNDEFTT) 
    throw InterpExc(SYNTAX); 
 
  return token_type; 
} 
 
// Zwr token do strumienia wejciowego.
void putback() 
{ 
  char *t; 
 
  t = token; 
  for(; *t; t++) prog--; 
} 
 
// Znajd wewntrzn reprezentacj tokenu w
// tabeli tokenw.
token_ireps look_up(char *s) 
{ 
  int i; 
  char *p; 
 
  // Przekszta na mae litery.
  p = s; 
  while(*p) { *p = tolower(*p); p++; } 
 
  // Sprawd, czy token jest w tablicy. 
  for(i=0; *com_table[i].command; i++) { 
    if(!strcmp(com_table[i].command, s)) 
      return com_table[i].tok; 
  } 
 
  return UNDEFTOK; // nieznane polecenie
} 
 
// Zwr indeks wewntrznej tablicy funkcji lub -1 gdy
// nie znaleziono.
int internal_func(char *s) 
{ 
  int i; 
 
  for(i=0; intern_func[i].f_name[0]; i++) { 
    if(!strcmp(intern_func[i].f_name, s))  return i; 
  } 
  return -1; 
} 
 
// Zwraca true, gdy c jest separatorem.
bool isdelim(char c) 
{ 
  if(strchr(" !:;,+-<>'/*%^=()", c) || c == 9 || 
     c == '\r' || c == 0) return true; 
  return false; 
}

