// Demonstrate basic RangeArray operations. 
#include <iostream> 
#include <algorithm> 
#include <functional> 
#include "ra.h" 
using namespace std; 
 
// Wywietl liczb cakowit int -- do wykorzystania w ptli for_each. 
void display(int v) 
{ 
  cout << v << " "; 
}   
 
int main() 
{ 
  RangeArray<int> ob(-5, 5, 0); 
  RangeArray<int>::iterator p; 
  int i, sum; 
 
  cout << "Rozmiar ob wynosi: " << ob.size() << endl; 
 
  cout << "Pocztkowa zawarto ob:\n"; 
  for(i=-5; i <= 5; i++) cout << ob[i] << " "; 
  cout << endl; 
 
  // Wstaw kilka wartoci do ob. 
  for(i=-5; i <= 5; i++) ob[i] = i; 
 
  cout << "Nowe wartoci w ob: \n"; 
  p = ob.begin(); 
  do { 
    cout << *p++ << " "; 
  } while (p != ob.end()); 
  cout << endl; 
 
  // Wywietl sum elementw o ujemnych indeksach. 
  sum = 0; 
  for(i = ob.getlowerbound(); i < 0; i++) 
    sum += ob[i]; 
  cout << "Suma wartoci o ujemnych indeksach wynosi: "; 
  cout << sum << "\n\n"; 
 
  // Uyj algorytmu copy() do skopiowania jednego obiektu do drugiego. 
  cout << "Skopiuj ob do ob2 przy uyciu algorytmu copy().\n"; 
 
  RangeArray<int> ob2(-5, 5, 0); 
  copy(ob.begin(), ob.end(), ob2.begin()); 
 
  // Wykorzystujc algorytm for_each(), wywietl zawarto ob2. 
  cout << "Zawarto ob2: \n"; 
  for_each(ob2.begin(), ob2.end(), display);  
  cout << "\n\n"; 
 
  // Wykorzystujc algorytm replace_copy_if(), usu wartoci mniejsze od zera. 
  cout << "Wartoci mniejsze od zera zamie na zera.\n";  
  cout << "Wynik umie w ob3.\n"; 
  RangeArray<int> ob3(ob.begin(), ob.end()); 
 
  // W nastpnej linii wykorzystujemy obiekt funkcyjny less()
  // oraz binder bind2nd(). 
  replace_copy_if(ob.begin(), ob.end(), ob3.begin(), 
                  bind2nd(less<int>(), 0), 0); 
  cout << "Zawarto ob3: \n"; 
  for_each(ob3.begin(), ob3.end(), display); 
  cout << "\n\n"; 
 
  cout << "Zamie ob i ob3.\n"; 
  ob.swap(ob3); // zamie ob i ob3 
  cout << "Oto ob3:\n"; 
  for_each(ob3.begin(), ob3.end(), display); 
  cout << endl; 
  cout << "Zamie te obiekty ponownie, aby przywrci poprzedni stan.\n"; 
  ob.swap(ob3); // przyracanie  
  cout << "Zawarto ob3 po ponownej zamianie:\n"; 
  for_each(ob3.begin(), ob3.end(), display); 
  cout << "\n\n"; 
 
  // Uyj metod insert(). 
  cout << "Element ob[0] to " << ob[0] << endl; 
  cout << "Wstawianie wartoci do ob.\n"; 
  ob.insert(ob.end(), -9999); 
  ob.insert(&ob[1], 99); 
  ob.insert(&ob[-3], -99); 
  for_each(ob.begin(), ob.end(), display); 
  cout << endl; 
  cout << "Element ob[0] to " << ob[0] << "\n\n"; 
 
  cout << "Wstaw liczb -7 trzy razy na pocztku ob.\n"; 
  ob.insert(ob.begin(), 3, -7); 
  for_each(ob.begin(), ob.end(), display); 
  cout << endl; 
  cout << "Element ob[0] to " << ob[0] << "\n\n"; 
 
  // Uyj metod push_back() i pop_back(). 
  cout << "Docz warto 40 do koca tablicy ob.\n"; 
  ob.push_back(40); 
  for_each(ob.begin(), ob.end(), display); 
  cout << endl; 
  cout << "Pobierz dwie wartoci z koca tablicy ob.\n"; 
  ob.pop_back(); ob.pop_back(); 
  for_each(ob.begin(), ob.end(), display); 
  cout << "\n\n"; 
 
  // Uyj metod push_front() i pop_front(). 
  cout << "Docz warto 19 do pocztku tablicy ob.\n"; 
  ob.push_front(19); 
  for_each(ob.begin(), ob.end(), display); 
  cout << endl; 
  cout << "Pobierz dwie wartoci z pocztku tablicy ob.\n"; 
  ob.pop_front(); ob.pop_front(); 
  for_each(ob.begin(), ob.end(), display); 
  cout << "\n\n"; 
 
  // Uyj metod front() and back() 
  cout << "ob.front(): " << ob.front() << endl; 
  cout << "ob.back(): " << ob.back() << "\n\n"; 
 
  // Uyj metody erase(). 
  cout << "Usu element na pozycji 0.\n"; 
  p = ob.erase(&ob[0]); 
  for_each(ob.begin(), ob.end(), display); 
  cout << endl; 
  cout << "Element ob[0] to " << ob[0] << endl; 
  cout << endl; 
 
  cout << "Usu kilka elementw z ob.\n"; 
  p = ob.erase(&ob[-2], &ob[3]); 
  for_each(ob.begin(), ob.end(), display); 
  cout << endl; 
  cout << "Element [0] to " << ob[0] << endl; 
  cout << endl; 
 
  cout << "Wstaw ob4 do ob.\n"; 
  RangeArray<int> ob4(0, 2, 0); 
  for(i=0; i < 3; i++) ob4[i] = i+100; 
  ob.insert(&ob[0], ob4.begin(), ob4.end()); 
  for_each(ob.begin(), ob.end(), display); 
  cout << endl; 
  cout << "Element ob[0] to " << ob[0] << endl; 
  cout << endl; 
 
  cout << "Oto tablica ob wraz z indeksami:\n"; 
  for(i=ob.getlowerbound(); i<ob.getupperbound(); i++) 
    cout << "[" << i << "]: " << ob[i] << endl; 
  cout << endl; 
 
  // Uyj funkcji at(). 
  cout << "Uycie funkcji at().\n"; 
  for(i=ob.getlowerbound(); i < ob.getupperbound(); i++) 
    ob.at(i) = i * 11; 
 
  for(i=ob.getlowerbound(); i < ob.getupperbound(); i++) 
    cout << ob.at(i) << " "; 
  cout << "\n\n"; 
 
  // Uyj funkcji clear(). 
  cout << "Czyszczenie ob.\n"; 
  ob.clear(); 
  for_each(ob.begin(), ob.end(), display); // nic nie wida! 
  cout << "Rozmiar ob po wykonaniu funkcji clear(): " << ob.size() 
       << "\nKrace: " << ob.getlowerbound() 
       << " do " << ob.getupperbound() << "\n\n"; 
 
  // Utwrz kopi obiektu. 
  cout << "Utwrz kopi ob2.\n"; 
  RangeArray<int> ob5(ob2); 
  for_each(ob5.begin(), ob5.end(), display); 
  cout << "\n\n"; 
   
  // Skontruuj nowy obiekt na podstawie zakresu wartoci. 
  cout << " Skontruuj nowy obiekt na podstawie zakresu wartoci.\n"; 
  RangeArray<int> ob6(&ob2[-2], ob2.end()); 
  cout << "Rozmiar ob6: " << ob6.size() << endl; 
  for_each(ob6.begin(), ob6.end(), display); 
  cout << endl; 
 
  return 0; 
}
