const int MAXDIST = 100000; 
 
// Wersja z przeszukiwaniem najmniejszego kosztu.
// Dla danego from znajd najdalsze poczenie.
// Zwraca warto true jeli poczenie zostao 
// znalezione i false w przeciwnym przypadku.
bool Search::find(string from, FlightInfo &f)  
{  
  int pos = -1; 
  int dist = MAXDIST; // duszy od najduszego lotu
 
  for(unsigned i=0; i < flights.size(); i++) {  
    if(flights[i].from == from && !flights[i].skip) {  
      // Uyj najkrtszego lotu. 
      if(flights[i].distance < dist) { 
        pos = i; 
        dist = flights[i].distance; 
      } 
    } 
  } 
   
  if(pos != -1) { 
    f = flights[pos]; 
    flights[pos].skip = true; // nie uywa ponownie
  
    return true;  
  }  
  
  return false;  
}

