// Panel kontrolny wtku.
  
#include <map> 
#include <windows.h>  
#include "panel.h"  
using namespace std; 
 
const int NUMPRIORITIES = 5; 
const int OFFSET = 2;  
 
// Tablica napisw dla listy rozwijanej priorytetw.
char priorities[NUMPRIORITIES][80] = {  
  "Najniszy",   
  "Poniej normalnego",   
  "Normalny",  
  "Powyej normalnego",  
  "Najwyszy"  
};  
 
// Klasa panela kontrolnego wtku.
class ThrdCtrlPanel { 
  // Informacja o kontrolowanym wtku.
  struct ThreadInfo { 
    HANDLE hThread; // uchwyt wtku
    int priority;   // aktualny priorytet
    bool suspended; // true jeli wtek wstrzymany
    ThreadInfo(HANDLE ht, int p, bool s) { 
      hThread = ht; 
      priority = p; 
      suspended = s; 
    } 
  }; 
 
  // Ta tablica asocjacyjna przechowuje obiekty ThreadInfo
  // dla wszystkich paneli kontrolnych watkw.
  static map<HWND, ThreadInfo> dialogmap; 
 
public:  
 
  // Konstruuje panel kontrolny.
  ThrdCtrlPanel(HINSTANCE hInst, HANDLE hThrd); 
 
  // Funkcja zwrotna panelu kontrolnego.
  static LRESULT CALLBACK ThreadPanel(HWND hwnd, UINT message,  
                         WPARAM wParam, LPARAM lParam); 
}; 
 
// Definicja skadowej statycznej dialogmap.
map<HWND, ThrdCtrlPanel::ThreadInfo> 
  ThrdCtrlPanel::dialogmap; 
 
// Utwrz panel kontrolny wtku.
ThrdCtrlPanel::ThrdCtrlPanel(HINSTANCE hInst, 
                             HANDLE hThrd) 
{ 
  ThreadInfo ti(hThrd,  
                GetThreadPriority(hThrd)+OFFSET, 
                false); 
   
  // Oknem rodzicielskim jest pulpit.
  HWND hDialog = CreateDialog(hInst, "ThreadPanelDB", 
                       NULL,  
                       (DLGPROC) ThreadPanel);  
   
  // W informacj o tym oknie dialogowym do tablicy asocjacyjnej.
  dialogmap.insert(pair<HWND, ThreadInfo>(hDialog, ti)); 
 
  // Ustaw tytu panelu kontrolnego.
  char str[80] = "Panel kontrolny dla wtku "; 
  char str2[4]; 
  _itoa(dialogmap.size(), str2, 10); 
  strcat(str, str2); 
  SetWindowText(hDialog, str);  
 
  // Przesu kad instancj okna dialogowego.
  MoveWindow(hDialog, 30*dialogmap.size(), 
             30*dialogmap.size(), 
             330, 250, 1); 
 
  // Uaktualnij ustawienie priorytetu w licie rozwijanej.
  SendDlgItemMessage(hDialog, IDD_LB, LB_SETCURSEL,   
                          (WPARAM) ti.priority, 0);  
 
  // Zwiksz priorytet aby zapewni kontrol. Moesz
  // zmieni lub usun t instrukcj w zalenoci od
  // rodowiska wykonywania.
  SetThreadPriority(GetCurrentThread(), 
                    THREAD_PRIORITY_ABOVE_NORMAL);  
} 
 
  
// Funkcja zwrotna okna dialogowego panela kontrolnego.
LRESULT CALLBACK ThrdCtrlPanel::ThreadPanel(HWND hwnd, 
                                      UINT message,  
                                      WPARAM wParam, 
                                      LPARAM lParam)  
{  
  int i;  
  HWND hpbRes, hpbSus, hpbTerm;  
 
  switch(message) {  
    case WM_INITDIALOG:   
      // Inicjalizacja listy priorytetw.
      for(i=0; i<NUMPRIORITIES; i++) {  
        SendDlgItemMessage(hwnd, IDD_LB,   
            LB_ADDSTRING, 0, (LPARAM) priorities[i]);  
        }  
  
       // Ustaw przyciski wstrzymaj i wznw dla wtku.
       hpbSus = GetDlgItem(hwnd, IDD_SUSPEND);  
       hpbRes = GetDlgItem(hwnd, IDD_RESUME);  
       EnableWindow(hpbSus, true);  // wcz przycisk Wstrzymaj
       EnableWindow(hpbRes, false); // wycz przycisk Wznw
       return 1;  
    case WM_COMMAND:  
      map<HWND, ThreadInfo>::iterator p = dialogmap.find(hwnd); 
  
      switch(LOWORD(wParam)) {  
        case IDD_TERMINATE:  
          TerminateThread(p->second.hThread, 0); 
 
          // Wycz przycisk Zakocz.
          hpbTerm = GetDlgItem(hwnd, IDD_TERMINATE);  
          EnableWindow(hpbTerm, false); // wycz
 
          // Wycz przyciski Wstrzymaj i Wznw.
          hpbSus = GetDlgItem(hwnd, IDD_SUSPEND);  
          hpbRes = GetDlgItem(hwnd, IDD_RESUME);  
          EnableWindow(hpbSus, false); // wycz przycisk Wstrzymaj
          EnableWindow(hpbRes, false); // wycz przycisk Wznw
 
          return 1;  
        case IDD_SUSPEND:  
          SuspendThread(p->second.hThread);  
 
          // Ustaw stan przyciskw Wstrzymaj i Wznw.
          hpbSus = GetDlgItem(hwnd, IDD_SUSPEND);  
          hpbRes = GetDlgItem(hwnd, IDD_RESUME);  
          EnableWindow(hpbSus, false); // wycz przycisk Wstrzymaj
          EnableWindow(hpbRes, true);  // wcz przycisk Wznw
 
          p->second.suspended = true;  
          return 1;  
        case IDD_RESUME:  
          ResumeThread(p->second.hThread);  
 
          // Ustaw stan przyciskw Wstrzymaj i Wznw.
          hpbSus = GetDlgItem(hwnd, IDD_SUSPEND);  
          hpbRes = GetDlgItem(hwnd, IDD_RESUME);  
          EnableWindow(hpbSus, true);  // wcz przycisk Wstrzymaj
          EnableWindow(hpbRes, false); // wycz przycisk Wznw
 
          p->second.suspended = false;  
          return 1;  
        case IDD_LB:  
          // Jeeli kliknity zosta element listy
          // zmie priorytet.
          if(HIWORD(wParam)==LBN_DBLCLK) { 
            p->second.priority = SendDlgItemMessage(hwnd, 
                                 IDD_LB, LB_GETCURSEL, 
                                 0, 0);  
            SetThreadPriority(p->second.hThread, 
                              p->second.priority-OFFSET);  
          } 
          return 1;   
        case IDCANCEL:   
          // Jeeli wtek jest wstrzymany przy zamykaniu panelu
          // wznw go, aby zapobiec zakleszczeniu.
          if(p->second.suspended) { 
            ResumeThread(p->second.hThread);  
            p->second.suspended = false; 
          } 
 
          // Usu ten wtek z listy.
          dialogmap.erase(hwnd); 
 
          // Zakmknij panel.
          DestroyWindow(hwnd); 
          return 1;  
      }  
   }  
   return 0;  
}

