// Demonstruje opuszczanie zasigu przez wskanik GCPtr 
// przed zakoczeniem programu
#include <iostream> 
#include <new> 
#include "gc.h" 
 
using namespace std; 
 
int main() { 
  GCPtr<int> p; 
  GCPtr<int> q; 
 
  try { 
    p = new int(10); 
    q = new int(11); 
 
    cout << "Warto wskazywana przez p wynosi: " << *p << endl; 
    cout << "Warto wskazywana przez q wynosi: " << *q << endl; 
     
    cout << "Przed wejciem do bloku.\n"; 
 
    // Teraz utwrz obiekt lokalny.
    { // pocztek bloku
      GCPtr<int> r = new int(12); 
      cout << "Warto wskazywana przez r wynosi: " << *r << endl; 
    } // koniec bloku powodujcy, e r wychodzi poza zasig
 
    cout << "Po wyjciu z bloku.\n"; 
 
  } catch(bad_alloc exc) { 
    cout << "Bd alokacji pamici!\n"; 
    return 1; 
  } 
 
  cout << "Gotowe\n"; 
 
  return 0; 
}

