// Jednowtkowy mechanizm odzyskiwania pamici.

#include <iostream>
#include <list>
#include <typeinfo>
#include <cstdlib>

using namespace std;

// Aby obserwowa dziaanie mechanizmu odzyskiwania pamici zdefinium makro DISPLAY.
#define DISPLAY

// Wyjtek zgaszany przy prbie uycia Iter
// wychodzcego poza zakres zwizanego z nim obiektu.
//
class OutOfRangeExc {
  // Dodaj funkcje jeli wymaga tego twoja aplikacja.
};

// Klasa zachowujca si jak iterator do poruszania si
// po tablicach wskazywanych przez GCPtrs. Wskaniki Iters
// ** nie ** bior udziau ani nie wpywaj na mechanizm
// odzyskiwania pamici. Zatem to, e Iter wskazuje na
// jaki obiekt nie zabezpiecza go przed zwolnieniem.
//
template <class T> class Iter {
  T *ptr;   // aktualna warto wskanika
  T *end;   // wskazuje na element za kocem
  T *begin; // wskazuje na pocztek zaalokowanej tablicy
  unsigned length; // dugo tablicy
public:

  Iter() {
    ptr = end = begin = NULL;
    length = 0;
  }

  Iter(T *p, T *first, T *last) {
    ptr =  p;
    end = last;
    begin = first;
    length = last - first;
  }

  // Zwraca dugo tablicy na ktr
  // wskazuje Iter.
  unsigned size() { return length; }

  // Zwraca warto wskazywan przez ptr.
  // Nie pozwala na dostp poza zakresem.
  T &operator*() {
    if( (ptr >= end) || (ptr < begin) )
      throw OutOfRangeExc();
    return *ptr;
  }

  // Zwraca adres zawarty w ptr.
  // Nie pozwala na dostp poza zakresem.
  T *operator->() {
    if( (ptr >= end) || (ptr < begin) )
      throw OutOfRangeExc();
    return ptr;
  }

  // Przedrostkowy operator ++.
  Iter operator++() {
    ptr++;
    return *this;
  }

  // Przedrostkowy operator --.
  Iter operator--() {
    ptr--;
    return *this;
  }

  // Przyrostkowy operator ++.
  Iter operator++(int notused) {
    T *tmp = ptr;

    ptr++;
    return Iter<T>(tmp, begin, end);
  }

  // Przyrostkowy operator --.
  Iter operator--(int notused) {
    T *tmp = ptr;

    ptr--;
    return Iter<T>(tmp, begin, end);
  }

  // Zwraca referencj do obiektu pod
  // podanym indeksem. Nie pozwala na
  // dostp poza zakresem.
  T &operator[](int i) {
    if( (i < 0) || (i >= (end-begin)) )
      throw OutOfRangeExc();
    return ptr[i];
  }

  // Definicje operatorw relacyjnych.
  bool operator==(Iter op2) {
    return ptr == op2.ptr;
  }

  bool operator!=(Iter op2) {
    return ptr != op2.ptr;
  }

  bool operator<(Iter op2) {
    return ptr < op2.ptr;
  }

  bool operator<=(Iter op2) {
    return ptr <= op2.ptr;
  }

  bool operator>(Iter op2) {
    return ptr > op2.ptr;
  }

  bool operator>=(Iter op2) {
    return ptr >= op2.ptr;
  }

  // Odejmuje liczb cakowit od Iter.
  Iter operator-(int n) {
    ptr -= n;
    return *this;
  }

  // Dodaje liczb cakowit do Iter.
  Iter operator+(int n) {
    ptr += n;
    return *this;
  }

  // Zwraca liczb elementw midzy dwoma obiektami Iter.
  int operator-(Iter<T> &itr2) {
    return ptr - itr2.ptr;
  }

};


// Ta klasa definiuje element przechowywany
// w licie informacyjnej mechanizmu odzyskiwania pamici.
//
template <class T> class GCInfo {
public:
  unsigned refcount; // aktualny licznik referencji

  T *memPtr; // wskanik do zaalokowanej pamici

  /* isArray ma warto true jeli memPtr wskazuje
     na zaalokowan tablic. W przeciwnym przypadku
     ma warto false. */
  bool isArray; // true jeeli wskazuje na tablic

  /* Jeli memPtr wskazuje na zaalokowan tablic
    to arraySize zawiera jej rozmiar */
  unsigned arraySize; // rozmiar tablicy

  // Tutaj mPtr wskazuje na zaalokowan pami.
  // Jeli jest to tablica, wtedy size okrela
  // rozmiar tablicy.
  GCInfo(T *mPtr, unsigned size=0) {
    refcount = 1;
    memPtr = mPtr;
    if(size != 0)
      isArray = true;
    else
      isArray = false;

    arraySize = size;
  }
};

// Przecienie operatora== pozwala na porwnywanie obiektw GCInfo.
// Jest wymagane przez klas list z biblioteki STL.
template <class T> bool operator==(const GCInfo<T> &ob1,
                const GCInfo<T> &ob2) {
  return (ob1.memPtr == ob2.memPtr);
}


// GCPtr implementuje typ wskanikowy uywajcy
// mechanizmu odzyskiwania pamici do zwalniania
// nieuywanej pamici. GCPtr moe by uywana tylko
// do wskazywania pamici dynamicznie zaalokowanej
// operatorem new. Jeli jest uyta do zaalokowanej
// tablicy, naley poda jej rozmiar.
//
template <class T, int size=0> class GCPtr {

  // gclist zawiera list mechanizmu odzyskiwania pamici.
  static list<GCInfo<T> > gclist;

  // addr wskazuje na zaalokowan pami na ktr
  // ten wskanik GCPtr wskazuje.
  T *addr;

  /* isArray ma warto true jeeli ten GCPtr
     wskazuje na zaalokowan tablic. W przeciwnym
     przypadku ma warto false. */
  bool isArray; // true jeeli wskazuje na tablic

  // Jeeli ten GCPtr wskazuje na zaalokowan
  // tablic, wtedy arraySize zawiera jej rozmiar.
  unsigned arraySize; // rozmiar tablicy

  static bool first; // true gdy tworzony jest pierwszy obiekt GCPtr

  // Zwraca iterator do informacji o wskaniku w gclist.
  typename list<GCInfo<T> >::iterator findPtrInfo(T *ptr);

public:

  // Definiuje typ iteratora dla GCPtr<T>.
  typedef Iter<T> GCiterator;

  // Konstruktor zainicjowanych i niezainicjowanych obiektw.
  GCPtr(T *t=NULL) {

    // Rejestruje shutdown() jako funkcj wyjcia.
    if(first) atexit(shutdown);
    first = false;

    list<GCInfo<T> >::iterator p;

    p = findPtrInfo(t);

    // Jeeli t ju jest w gclist to
    // zwiksza jego licznik referencji.
    // W przeciwnym razie dodaj je do listy.
    if(p != gclist.end())
      p->refcount++; // zwiksz licznik referencji
    else {
      // Utwrz i zapamitaj ten element.
      GCInfo<T> gcObj(t, size);
      gclist.push_front(gcObj);
    }

    addr = t;
    arraySize = size;
    if(size > 0) isArray = true;
    else isArray = false;
    #ifdef DISPLAY
      cout << "Tworzenie GCPtr. ";
      if(isArray)
        cout << " Rozmiar wynosi " << arraySize << endl;
      else
        cout << endl;
    #endif
  }

  // Konstruktor kopiujcy.
  GCPtr(const GCPtr &ob) {
    list<GCInfo<T> >::iterator p;

    p = findPtrInfo(ob.addr);
    p->refcount++; // zwiksz licznik referencji

    addr = ob.addr;
    arraySize = ob.arraySize;
    if(arraySize > 0) isArray = true;
    else isArray = false;
    #ifdef DISPLAY
      cout << "Tworzenie kopii.";
      if(isArray)
        cout << " Rozmiar wynosi " << arraySize << endl;
      else
        cout << endl;
    #endif
  }

  // Destruktor klasy GCPtr.
  ~GCPtr();

  // Odzyskuje nieuywan pami. Zwraca true, jeli
  // ostatni obiekt zosta zwolniony.
  static bool collect();

  // Przeciony operator przypisania wskanika do obiektu GCPtr.
  T *operator=(T *t);

  // Przeciony operator przypisania obiektu GCPtr do obiektu GCPtr.
  GCPtr &operator=(GCPtr &rv);

  // Zwraca referencj do obiektu wskazywanego
  // przez ten GCPtr.
  T &operator*() {
    return *addr;
  }

  // Zwraca wskazywany adres.
  T *operator->() { return addr; }

  // Zwraca referencj do obiektu pod
  // indeksem i.
  T &operator[](int i) {
    return addr[i];
  }

  // Operator rzutowania na T *.
  operator T *() { return addr; }

  // Zwraca iterator Iter ma pocztek zaalokowanej pamici.
  Iter<T> begin() {
    int size;

    if(isArray) size = arraySize;
    else size = 1;

    return Iter<T>(addr, addr, addr + size);
  }

  // Zwraca iterator Iter na element za kocem zaalokowanej pamici.
  Iter<T> end() {
    int size;

    if(isArray) size = arraySize;
    else size = 1;

    return Iter<T>(addr + size, addr, addr + size);
  }

  // Zwraca dugo listy gclist dla tego typu GCPtr.
  static int gclistSize() { return gclist.size(); }

  // Funkcja pomocnicza wywietlajca zawarto listy gclist.
  static void showlist();

  // Czyci list gclist przy wyjciu z programu.
  static void shutdown();
};

// Rezerwuje pami na zmienne statyczne.
template <class T, int size>
  list<GCInfo<T> > GCPtr<T, size>::gclist;

template <class T, int size>
  bool GCPtr<T, size>::first = true;

// Destruktor klasy GCPtr.
template <class T, int size>
GCPtr<T, size>::~GCPtr() {
  list<GCInfo<T> >::iterator p;

  p = findPtrInfo(addr);
  if(p->refcount) p->refcount--; // zmniejszamy licznik referencji

  #ifdef DISPLAY
    cout << "GCPtr wychodzi poza zasig.\n";
  #endif

  // Odzyskaj pami, gdy wskanik wychodzi poza zasig.
  collect();

  // W prawdziwym programie bdziesz chcia odzyskiwa
  // nieuywan pami rzadziej, na przykad po tym,
  // jak gclist osignie okrelony rozmiar, po
  // wyjciu poza zasig okrelonej liczby obiektw
  // GCPtr lub gdy zostao mao pamici.
}

// Odzyskuje nieuywan pami. Zwraca true, jeli
// ostatni zosta zwolniony.
template <class T, int size>
bool GCPtr<T, size>::collect() {
  bool memfreed = false;

  #ifdef DISPLAY
    cout << "Przed odzyskiwaniem pamici dla ";
    showlist();
  #endif

  list<GCInfo<T> >::iterator p;
  do {

    // Przegldanie gclist w poszukiwaniu wskanikw,
    // do ktrych nie ma odwoa.
    for(p = gclist.begin(); p != gclist.end(); p++) {
      // Pomi jeli w uyciu.
      if(p->refcount > 0) continue;

      memfreed = true;


      // Zwalniaj pami a GCPtr ma warto null.
      if(p->memPtr) {
        if(p->isArray) {
          #ifdef DISPLAY
            cout << "Kasowanie tablicy o dugoci "
                 << p->arraySize << endl;
          #endif
          delete[] p->memPtr; // kasowanie tablicy
        }
        else {
          #ifdef DISPLAY
            cout << "Kasowanie: "
                 << *(T *) p->memPtr << "\n";
          #endif
          delete p->memPtr; // kasowanie pojedynczego obiektu
        }
      }

       // Usu nieuywany wpis z listy gclist.

      gclist.remove(*p);

      // Rozpocznij szukanie od pocztku.
      break;
    }

  } while(p != gclist.end());

  #ifdef DISPLAY
    cout << "Po odzyskiwaniu pamici dla ";
    showlist();
  #endif

  return memfreed;
}

// Przeciony operator przypisania wskanika do obiektu GCPtr.
template <class T, int size>
T * GCPtr<T, size>::operator=(T *t) {
  list<GCInfo<T> >::iterator p;

  // Najpierw zmniejsz licznik referencji
  // do aktualnie wskazywanej pamici.
  p = findPtrInfo(addr);
  p->refcount--;

  // Nastpnie jeli nowy adres ju istnieje
  // w systemie, zwiksz jego licznik.
  // W przeciwnym razie utwrz nowy element
  // dla listy gclist.
  p = findPtrInfo(t);
  if(p != gclist.end())
    p->refcount++;
  else {
    // Utwrz i zapamitaj ten element.
    GCInfo<T> gcObj(t, size);
    gclist.push_front(gcObj);
  }

  addr = t; // zapamitaj adres

  return t;
}

// Przeciony operator przypisania obiektu GCPtr do obiektu GCPtr.
template <class T, int size>
GCPtr<T, size> & GCPtr<T, size>::operator=(GCPtr &rv) {
  list<GCInfo<T> >::iterator p;

  // Najpierw zmniejsz licznik referencji
  // do aktualnie wskazywanej pamici.
  p = findPtrInfo(addr);
  p->refcount--;

  // Nastnie zwiksz licznik referencji
  // do nowego adresu.
  p = findPtrInfo(rv.addr);
  p->refcount++; // zwiksz licznik referencji

  addr = rv.addr;// zapamitaj adres

  return rv;
}

// Funkcja pomocnicza wywietlajca list gclist.
template <class T, int size>
void GCPtr<T, size>::showlist() {
  list<GCInfo<T> >::iterator p;

  cout << "gclist<" << typeid(T).name() << ", "
       << size << ">:\n";
  cout << "memPtr      refcount    value\n";

  if(gclist.begin() == gclist.end()) {
    cout << "           -- Pusta --\n\n";
    return;
  }

  for(p = gclist.begin(); p != gclist.end(); p++) {
    cout <<  "[" << (void *)p->memPtr << "]"
         << "      " << p->refcount << "     ";
    if(p->memPtr) cout << "   " << *p->memPtr;
    else cout << "   ---";
    cout << endl;
  }
  cout << endl;
}

// Wyszukuje wskanik w licie gclist.
template <class T, int size>
typename list<GCInfo<T> >::iterator
  GCPtr<T, size>::findPtrInfo(T *ptr) {

  list<GCInfo<T> >::iterator p;

  // Znajd ptr w licie gclist.
  for(p = gclist.begin(); p != gclist.end(); p++)
    if(p->memPtr == ptr)
      return p;

  return p;
}

// Czyci list gclist przy wyjciu z programu.
template <class T, int size>
void GCPtr<T, size>::shutdown() {

  if(gclistSize() == 0) return; // lista jest pusta

  list<GCInfo<T> >::iterator p;

  for(p = gclist.begin(); p != gclist.end(); p++) {
    // wyzeruj wszystkie liczniki referencji
    p->refcount = 0;
  }

  #ifdef DISPLAY
    cout << "Przed odzyskiwaniem pamici w funkcji shutdown() dla "
         << typeid(T).name() << "\n";
  #endif

  collect();

  #ifdef DISPLAY
    cout << "Po odzyskiwaniu pamici w funkcji shutdown() dla "
         << typeid(T).name() << "\n";
  #endif
}

