// Szukanie optymalnego rozwizania przy uyciu
// metody najmniejszego kosztu z usuwaniem cieek.
#include <iostream> 
#include <stack> 
#include <string> 
#include <vector> 
 
using namespace std; 
  
// Informacja o locie.
struct FlightInfo {  
  string from;  // miasto odlotu
  string to;    // miasto przylotu
  int distance; // odlego midzy miastami
  bool skip;    // uywane przy zawracaniu
  
  FlightInfo() { 
    from = ""; 
    to = ""; 
    distance = 0; 
    skip = false; 
  } 
 
  FlightInfo(string f, string t, int d) {  
    from = f;  
    to = t;  
    distance = d;  
    skip = false;  
  }  
};  
 
const int MAXDIST = 100000; 
 
// Znajd poczenia uywajc metody najmniejszego kosztu.
class Optimal {  
  // Ten wektor przechowuje informacje o lotach.
  vector<FlightInfo> flights; 
 
  // Ten stos jest uywany przy zawracaniu.
  stack<FlightInfo> btStack;  
 
  // Ten stos trzyma optymalne rozwizanie.
  stack<FlightInfo> optimal;  
 
  int minDist; 
 
  // Jeeli istnieje lot midzy from i to,
  // zachowaj dugo lotu w zmiennej dist.
  // Zwraca true jeli lot istnieje,
  // false w przeciwnym razie. 
  bool match(string from, string to, int &dist); 
 
  // Znajd dowolne poczenie z from.
  // Zwraca true jeli istnieje poczenie,
  // false w przeciwnym razie. 
  bool find(string from, FlightInfo &f); 
 
public:  
 
  // Konstruktor
  Optimal() { 
    minDist = MAXDIST; 
  } 
 
  // Dodaj lot do bazy danych
  void addflight(string from, string to, int dist) {  
    flights.push_back(FlightInfo(from, to, dist));  
  } 
 
  // Poka tras i cakowit odlego
  void route();  
 
  // Wywietl optymaln tras.
  void Optimal::showOpt(); 
 
  // Okrel czy istnieje trasa midzy from a to
  void findroute(string from, string to); 
 
  // Zwraca true jeli trasa zostaa znaleziona.
  bool routefound() { 
    return btStack.size() != 0; 
  } 
};  
 
// Poka tras i cakowit odlego
void Optimal::route()  
{  
  stack<FlightInfo> optTemp;  
  int dist = 0;  
  FlightInfo f;  
  
  // Odwr stos, aby pokaza tras.
  while(!btStack.empty()) { 
    f = btStack.top(); 
    optTemp.push(f); 
    btStack.pop(); 
    dist += f.distance; 
  } 
  
  // Jeeli krtsza, to j zapamitaj.
  if(minDist > dist) { 
    optimal = optTemp; 
    minDist = dist; 
  } 
} 
 
// Wywietl optymaln tras.
void Optimal::showOpt() 
{ 
  FlightInfo f; 
  int dist = 0; 
 
  cout <<"Optymalne rozwizanie:\n";  
 
  // Wywietl optalne rozwizanie
  while(!optimal.empty()) { 
    f = optimal.top(); 
    optimal.pop();  
    cout << f.from << " - ";  
    dist += f.distance;  
  }  
  
  cout << f.to << endl;  
  cout << "Odlego wynosi " << dist << endl;  
}  
  
// Jeeli istnieje lot midzy from i to,
// zachowaj dugo lotu w zmiennej dist.
// Zwraca true jeli lot istnieje,
// false w przeciwnym razie. 
bool Optimal::match(string from, string to, int &dist)  
{  
  for(unsigned i=0; i < flights.size(); i++) {  
    if(flights[i].from == from &&  
       flights[i].to == to && !flights[i].skip)  
    {  
      flights[i].skip = true; // nie uywa ponownie
      dist = flights[i].distance; 
      return true; 
    }  
  }  
  
  return false; // nie znaleziono
}  
    
// Wersja z przeszukiwaniem najmniejszego kosztu.
// Dla danego from znajd najdalsze poczenie.
// Zwraca warto true jeli poczenie zostao 
// znalezione i false w przeciwnym przypadku.
bool Optimal::find(string from, FlightInfo &f)  
{  
  int pos = -1; 
  int dist = MAXDIST; // duszy od najduszego lotu
 
  for(unsigned i=0; i < flights.size(); i++) {  
    if(flights[i].from == from && !flights[i].skip)  
    {  
      // Uyj najkrtszego lotu. 
      if(flights[i].distance < dist) { 
        pos = i; 
        dist = flights[i].distance; 
      } 
    } 
  } 
   
  if(pos != -1) { 
    f = flights[pos]; 
    flights[pos].skip = true; // nie uywa ponownie
  
    return true;  
  }  
  
  return false;  
}  
    
// Okrel czy istnieje trasa midzy from a to
void Optimal::findroute(string from, string to)  
{  
  int dist;  
  FlightInfo f;  
  
  // Zobacz czy w miejscu przylotu
  if(match(from, to, dist)) { 
    btStack.push(FlightInfo(from, to, dist));  
    return;  
  }  
  
  // Sprbuj innego poczenia
  if(find(from, f)) { 
    btStack.push(FlightInfo(from, to, f.distance));  
    findroute(f.to, to);  
  }  
  else if(!btStack.empty()) {  
    // Zawr i sprbuj innego poczenia
    f = btStack.top(); 
    btStack.pop();  
    findroute(f.from, f.to);  
  }  
} 
 
// Szukanie optymalnego rozwizania przy uyciu
// metody najmniejszego kosztu z usuwaniem cieek.
int main() {  
  char to[40], from[40]; 
  Optimal ob; 
 
  // Dodaj poczenia do bazy danych.
  ob.addflight("Nowy Jork", "Chicago", 1440);  
  ob.addflight("Chicago", "Denver", 1600);  
  ob.addflight("Nowy Jork", "Toronto", 800);  
  ob.addflight("Nowy Jork", "Denver", 2880);  
  ob.addflight("Toronto", "Calgary", 2720);  
  ob.addflight("Toronto", "Los Angeles", 4000);  
  ob.addflight("Toronto", "Chicago", 800);  
  ob.addflight("Denver", "Urbana", 1600);  
  ob.addflight("Denver", "Houston", 1600);  
  ob.addflight("Houston", "Los Angeles", 2400);  
  ob.addflight("Denver", "Los Angeles", 1600);  
 
  // Zapytaj si o miasta odlotu i przylotu.  
  cout << "Z? ";  
 
  cin.getline(from, 40); 
  cout << "Do? ";  
 
  cin.getline(to, 40); 
 
  // Znajd wiele rozwiza.
  for(;;) { 
    // Sprawd, czy istnieje trasa midzy from i to.
    ob.findroute(from, to);  
  
    // zakocz jeli nie znaleziono trasy.
    if(!ob.routefound()) break; 
 
    ob.route();  
  } 
 
  // Wywietl optymalne rozwizanie.
  ob.showOpt();  
 
  return 0; 
 
} 
 
