// Szukanie trasy.
#include <iostream> 
#include <stack> 
#include <string> 
#include <vector> 
 
using namespace std; 
  
// Informacja o locie.
struct FlightInfo {  
  string from;  // miasto odlotu
  string to;    // miasto przylotu
  int distance; // odlego midzy miastami
  bool skip;    // uywane przy zawracaniu
  
  FlightInfo() { 
    from = ""; 
    to = ""; 
    distance = 0; 
    skip = false; 
  } 
 
  FlightInfo(string f, string t, int d) {  
    from = f;  
    to = t;  
    distance = d;  
    skip = false;  
  }  
};  
 
// Znajd poczenia uywajc przeszukiwania w gb.
class Search {  
  // Ten wektor przechowuje informacje o lotach.
  vector<FlightInfo> flights; 
 
  // Ten stos jest uywany przy zawracaniu.
  stack<FlightInfo> btStack;  
 
  // Jeeli istnieje lot midzy from i to,
  // zachowaj dugo lotu w zmiennej dist.
  // Zwraca true jeli lot istnieje,
  // false w przeciwnym razie. 
  bool match(string from, string to, int &dist); 
 
  // Znajd dowolne poczenie z from.
  // Zwraca true jeli istnieje poczenie,
  // false w przeciwnym razie. 
  bool find(string from, FlightInfo &f); 
 
public:  
 
  // Dodaj lot do bazy danych
  void addflight(string from, string to, int dist) {  
    flights.push_back(FlightInfo(from, to, dist));  
  }  
 
  // Poka tras i cakowit odlego
  void route();  
 
  // Okrel czy istnieje trasa midzy from a to
  void findroute(string from, string to); 
 
  // Zwraca true jeli trasa zostaa znaleziona.
  bool routefound() { 
    return !btStack.empty(); 
  } 
};  
 
// Poka tras i cakowit odlego
void Search::route()  
{  
  stack<FlightInfo> rev;  
  int dist = 0;  
  FlightInfo f;  
  
  // Odwr stos, aby pokaza tras.
  while(!btStack.empty()) { 
    f = btStack.top(); 
    rev.push(f); 
    btStack.pop(); 
  } 
  
  // Poka tras.
  while(!rev.empty()) { 
    f = rev.top(); 
    rev.pop();  
    cout << f.from << " - ";  
    dist += f.distance;  
  }  
  
  cout << f.to << endl;  
  cout << "Odlego wynosi " << dist << endl;  
}  
  
// Jeeli istnieje lot midzy from i to,
// zachowaj dugo lotu w zmiennej dist.
// Zwraca true jeli lot istnieje,
// false w przeciwnym razie. 
bool Search::match(string from, string to, int &dist)  
{  
  for(unsigned i=0; i < flights.size(); i++) {  
    if(flights[i].from == from &&  
       flights[i].to == to && !flights[i].skip)  
    {  
      flights[i].skip = true; // nie uywa ponownie
      dist = flights[i].distance; 
      return true; 
    }  
  }  
  
  return false; // nie znaleziono
}  
    
// Znajd dowolne poczenie z from.
// Zwraca true jeli istnieje poczenie,
// false w przeciwnym razie. 
bool Search::find(string from, FlightInfo &f)  
{  
  for(unsigned i=0; i < flights.size(); i++) {  
    if(flights[i].from == from && !flights[i].skip) {  
      f = flights[i]; 
      flights[i].skip = true; // nie uywa ponownie
  
      return true;  
    }  
  }  
  
  return false;  
}  
  
// Wersja z przeszukiwaniem w gb.
// Okrel czy istnieje trasa midzy from a to
void Search::findroute(string from, string to)  
{  
  int dist;  
  FlightInfo f;  
  
  // Zobacz czy w miejscu przylotu
  if(match(from, to, dist)) { 
    btStack.push(FlightInfo(from, to, dist));  
    return;  
  }  
  
  // Sprbuj innego poczenia
  if(find(from, f)) { 
    btStack.push(FlightInfo(from, to, f.distance));  
    findroute(f.to, to);  
  }  
  else if(!btStack.empty()) {  
    // Zawr i sprbuj innego poczenia
    f = btStack.top(); 
    btStack.pop();  
    findroute(f.from, f.to);  
  }  
} 
 
int main() {  
  char to[40], from[40]; 
  Search ob; 
 
  // Dodaj poczenia do bazy danych.
  ob.addflight("Nowy Jork", "Chicago", 1440);  
  ob.addflight("Chicago", "Denver", 1600);  
  ob.addflight("Nowy Jork", "Toronto", 800);  
  ob.addflight("Nowy Jork", "Denver", 2880);  
  ob.addflight("Toronto", "Calgary", 2720);  
  ob.addflight("Toronto", "Los Angeles", 4000);  
  ob.addflight("Toronto", "Chicago", 800);  
  ob.addflight("Denver", "Urbana", 1600);  
  ob.addflight("Denver", "Houston", 1600);  
  ob.addflight("Houston", "Los Angeles", 2400);  
  ob.addflight("Denver", "Los Angeles", 1600);  
 
  // Zapytaj si o miasta odlotu i przylotu.    
  cout << "Z? ";  
 
  cin.getline(from, 40); 
  cout << "Do? ";  
 
  cin.getline(to, 40); 
 
  // Sprawd, czy istnieje trasa midzy from i to.
  ob.findroute(from, to);  
  
  // Jeeli istnieje trasa, to j poka.
  if(ob.routefound())  
      ob.route();  
 
  return 0; 
}

