// Podsystem realizujcy ciganie pliku z internetu.
#include <iostream>  
#include <windows.h>  
#include <wininet.h>  
#include <fstream>  
#include <cstdio>  
  
using namespace std;  
  
const int MAX_ERRMSG_SIZE = 80;  
const int MAX_FILENAME_SIZE = 512;  
const int BUF_SIZE = 1024;  
  
// Klasa wyjtkw do obsugi bdw podczas cigania.  
class DLExc {  
  char err[MAX_ERRMSG_SIZE];  
public:  
  DLExc(char *exc) {  
    if(strlen(exc) < MAX_ERRMSG_SIZE)  
      strcpy(err, exc);  
  }  
  
  // Zwraca wskanik komunikatu o bdzie.  
  const char * geterr() {  
    return err;  
  }  
};  
  
// Klasa obsugujca ciganie plikw z internetu.
class Download {  
  static bool ishttp(char *url);  
  static bool httpverOK(HINTERNET hIurl);  
  static bool getfname(char *url, char *fname);  
  static unsigned long openfile(char *url, bool reload,  
                                ofstream &fout);  
public:  
  static bool download(char *url, bool restart=false,  
     void (*update)(unsigned long, unsigned long)=NULL);  
};  
  
  
// ciganie pliku.
//  
// Przekazywanie adresu URL pliku poprzez argument url.  
//  
// Aby ponownie cign plik, do funkcji reload naley przekaza
// dodatkowy argument o wartoci true  
//  
// Aby wskaza funkcj update, wywoywan za kadym razem po zapenieniu bufora,
// podaj wskanik do tej funkcji jako trzeci argument.
// Jeeli funkcja update nie jest potrzebna
// nie podawaj wskanika - warto domylna wynosi null.  

bool Download::download(char *url, bool reload,   
       void (*update)(unsigned long, unsigned long)) {  
  
  ofstream fout;           // strumie wyjciowy  
  unsigned char buf[BUF_SIZE]; // bufor wejciowy  
  unsigned long numrcved;  // liczba przeczytanych bajtw  
  unsigned long filelen;   // dugo pliku na dysku  
  HINTERNET hIurl, hInet;  // uchwyty internetowe  
  unsigned long contentlen; // dugo ciganej zawartoci  
  unsigned long len;       // rozmiar dugoci ciganej zawartoci  
  unsigned long total = 0; // liczba otrzymanych bajtw  
  char header[80];         // nagwek Range
  
  try {  
    if(!ishttp(url))  
      throw DLExc("Adres URL musi by daniem protokou HTTP.");  
  
 // Otwieranie pliku pod podanym adresem URL.  
   // W wyniku otrzymamy uchwyt do otwartego strumienia zapisany w zmiennej fout.
   // Jeeli argument reload ma warto true  
   // i plik istnia wczeniej, jego zawarto zostanie usunita.
   // Zwracana jest dugo istniejcego pliku (po moliwym obciciu).

    filelen = openfile(url, reload, fout);  
  
    // Sprawdzamy, czy poczenie z internetem jest dostpne.  
    if(InternetAttemptConnect(0) != ERROR_SUCCESS)   
      throw DLExc("Nie mona otworzy poczenia z internetem");  
  
    // Otwieranie poczenia internetowego.
    hInet = InternetOpen("downloader",  
                        INTERNET_OPEN_TYPE_DIRECT,  
                        NULL, NULL,  0);  
  
    if(hInet == NULL)   
      throw DLExc("Nie mona nawiza poczenia.");  
  
    // Budowanie nagwka dania o dane.  
    sprintf(header, "Range:bytes=%d-", filelen);   
  
    // Otwieranie adresu i wykonanie dania o dane.  
    hIurl = InternetOpenUrl(hInet, url,  
              header, -1,  
              INTERNET_FLAG_NO_CACHE_WRITE, 0);  
  
    if(hIurl == NULL) throw DLExc("Nie mona otworzy poczenia z podanym adresem URL.");  
  
    // Sprawdzenie, czy obsugiwany jest protok HTTP/1.1 lub pniejszy.  
    if(!httpverOK(hIurl))  
      throw DLExc("HTTP/1.1 nie jest obsugiwany.");  
     
    // Pobieranie dugoci pobieranej zawartoci.  
    len = sizeof contentlen;  
    if(!HttpQueryInfo(hIurl,  
                      HTTP_QUERY_CONTENT_LENGTH |  
                      HTTP_QUERY_FLAG_NUMBER,  
                      &contentlen, &len, NULL))  
      throw DLExc("Nie znaleziono pliku lub nie mona pobra jego dugoci.");  
  
    // Jeeli istniejcy plik nie jest kompletny (jeli w ogle istnieje),  
          // naley ukoczy pobieranie.
    if(filelen != contentlen && contentlen)   
      do {  
        // Pobierz fragment pliku do bufora.  
        if(!InternetReadFile(hIurl, &buf,  
                             BUF_SIZE, &numrcved))  
          throw DLExc("Wystpi bd podczas pobierania.");  
  
         // Zapisz zawarto bufora na dysku.  
         fout.write((const char *) buf, numrcved);  
         if(!fout.good())   
           throw DLExc("Bd podczas zapisu na dysku.");  
       
         total += numrcved; // zwikszanie licznika przeczytanych bajtw  
  
         // Wywoaj funkcj update, jeli zostaa okrelona.  
         if(update && numrcved > 0)  
           update(contentlen+filelen, total+filelen);  
  
      } while(numrcved > 0);  
    else  
      if(update)  
        update(filelen, filelen);  
  
  } catch(DLExc) {  
    fout.close();  
    InternetCloseHandle(hIurl);  
    InternetCloseHandle(hInet);  
  
    throw; // ponowne wyrzucenie wyjtka
  }  
  
  fout.close();  
  InternetCloseHandle(hIurl);  
  InternetCloseHandle(hInet);  
  
  return true;  
}  
  
// Zwraca warto true, jeli obsugiwana jest wersja 1.1
// lub pniejsza protokou HTTP.  
bool Download::httpverOK(HINTERNET hIurl) {  
  char str[80];  
  unsigned long len = 79;  
  
  // Pobranie obsugiwanej wersji protokou HTTP.  
  if(!HttpQueryInfo(hIurl, HTTP_QUERY_VERSION, &str, &len, NULL))  
    return false;  
 
  // Najpierw sprawdzony zostanie pierwszorzdny numer wersji.  
  char *p = strchr(str, '/'); 
  p++; 
  if(*p == '0') return false; // obsugiwana wersja to HTTP 0.x 
 
  // Teraz odszukiwany jest pocztek drugorzdnego numeru wersji protokou HTTP
  p = strchr(str, '.');  
  p++;  
  
  // Znaleziony numer przeksztacany jest na liczb cakowit typu int.
  int minorVerNum = atoi(p);  
  
  if(minorVerNum > 0) return true;  
  return false;  
}  
  
// Pobieranie nazwy pliku z adresu URL. Jeeli nazwa nie moe by ustalona,
// zwracana jest warto false
bool Download::getfname(char *url, char *fname) {  
  // Szukanie ostatniego znaku /.  
  char *p = strrchr(url, '/');  
  
  // Kopiowanie nazwy pliku po ostatnim znaku /.   
  if(p && (strlen(p) < MAX_FILENAME_SIZE)) {  
    p++;  
    strcpy(fname, p);  
    return true;  
  }  
  else  
    return false;  
}  
  
// Otwieranie pliku wyjciowego oraz inicjalizacja
// strumienia wyjciowego. Warto zwracana to dugo pliku.
// Jeeli warto argumentu reload wynosi true, naley najpierw usun zawarto pliku,
// jeeli plik ju istnieje.
unsigned long Download::openfile(char *url,  
                                 bool reload,  
                                 ofstream &fout) {  
  char fname[MAX_FILENAME_SIZE];  
  
  if(!getfname(url, fname))   
    throw DLExc("File name error.");  
  
  if(!reload)   
    fout.open(fname, ios::binary | ios::out |  
                     ios::app | ios::ate);    
  else  
    fout.open(fname, ios::binary | ios::out |  
                     ios::trunc);    
  
  if(!fout)  
    throw DLExc("Nie mona otworzy pliku wyjcowego");    
  
  // Pobierz biec dugo pliku.  
  return fout.tellp();  
}  
  
// Sprawd, czy adres URL zawiera nazw protokou HTTP.  
bool Download::ishttp(char *url) {  
  char str[5] = "";  
  
  // Pobierz pierwsze cztery znaki adresu URL.  
  strncpy(str, url, 4);  
  
  // Przekszta na mae litery  
  for(char *p=str; *p; p++) *p = tolower(*p);  
    
  return !strcmp("http", str);  
}
