// Test obcieniowy klasy GCPtr przez wielokrotne 
// alokowanie i porzucanie tysicy obiektw.
#include <iostream> 
#include <new> 
#include <limits> 
#include "gc.h" 
 
using namespace std; 
 
// Prosta klasa do testu obcieniowego.
class LoadTest { 
  int a, b; 
public: 
  double n[100000]; // do zabrania pamici
  double val; 
 
  LoadTest() { a = b = 0; } 
 
  LoadTest(int x, int y) { 
    a = x; 
    b = y; 
    val = 0.0; 
  } 
 
  friend ostream &operator<<(ostream &strm, LoadTest &obj); 
}; 
 
// Wyjciowy operator strumieniowy dla klasy LoadTest. 
ostream &operator<<(ostream &strm, LoadTest &obj) { 
  strm << "(" << obj.a << " " << obj.b << ")"; 
  return strm; 
} 
 
int main() { 
  GCPtr<LoadTest> mp; 
  int i; 
 
  for(i = 1; i < 20000; i++) { 
    try { 
      mp = new LoadTest(i, i); 
    } catch(bad_alloc xa) { 
      // Gdy wystpi bd alokacji, odzyskaj nieuywan pami
      // wywoujc funkcj collect().
      cout << "Ostatni obiekt: " << *mp << endl; 
      cout << "Dugo listy gclist przed wywoaniem funkcji collect(): " 
           << mp.gclistSize() << endl; 
      GCPtr<LoadTest>::collect(); 
      cout << "Dugo po wywoaniu funkcji collect(): " 
           << mp.gclistSize() << endl; 
    } 
  } 
   
  return 0; 
}

