// Umieszcza obiekty przykadowej klasy w tablicy RangeArray. 
#include <iostream> 
#include "ra.h" 
 
using namespace std; 
 
class test { 
public: 
  int a; 
 
  test() { cout << "Konstruowanie\n"; a=0; } 
 
  test(const test &o) { 
    cout << "Konstruktor kopiujcy\n"; 
    a = o.a; 
  } 
 
  ~test() { cout << "Niszczenie\n"; } 
}; 
 
int main() 
{ 
  RangeArray<test> t(-3, 1, test()); 
  int i; 
 
  cout << "Oryginalna zawarto t:\n"; 
  for(i=-3; i < 2; i++) cout << t[i].a << " "; 
  cout << endl; 
 
  // Wstaw kilka wartoci do t. 
  for(i=-3; i < 2; i++) t[i].a = i; 
 
  cout << "Nowa zawarto t:\n"; 
  for(i=-3; i < 2; i++) cout << t[i].a << " "; 
  cout << endl; 
 
  // Skopiuj t do nowego kontenera. 
  RangeArray<test> t2(-7, 3, test()); 
  copy(t.begin(), t.end(), &t2[-2]); 
 
  cout << "Zawarto t2:\n"; 
  for(i=-7; i < 4; i++) cout << t2[i].a << " "; 
  cout << endl; 
 
  RangeArray<test> t3(t.begin()+1, t.end()-1); 
  cout << "Zawarto t3:\n"; 
  for(i=t3.getlowerbound(); i < t3.getupperbound(); i++)  
    cout << t3[i].a << " "; 
  cout << endl; 
 
  t.clear(); 
 
  cout << "Rozmiar tablicy po uyciu metody clear(): " << t.size() << endl; 
 
  // Przypisanie obiektu kontenera. 
  t = t3; 
  cout << "Zawarto t:\n"; 
  for(i=t.getlowerbound(); i<t.getupperbound(); i++) 
    cout << t[i].a << " "; 
  cout << endl; 
 
  return 0; 
}
