/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
template<typename T, typename A1, typename A2>
class A_Subscript {
  public:
    // konstruktor inicjalizujcy referencje do operandw
    A_Subscript (A1 const & a, A2 const & b)
     : a1(a), a2(b) {
    }

    // realizuj indeksowanie
    T operator[] (size_t idx) const {
        return a1[a2[idx]];
    }
    T& operator[] (size_t idx) {
        return a1[a2[idx]];
    }

    // size jest rozmiarem tablicy wewntrznej
    size_t size() const {
        return a2.size();
    }

  private:
    A1 const & a1;    // referencja do pierwszego operand
    A2 const & a2;    // referencja do drugiego operand
};
