/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <stddef.h>
#include <cassert>

// docz do kodu pomocniczy szablon klasy cech, sucy do wyboru, czy odwoanie do
// "wza szablonu wyraenia" bdzie odwoaniem przez warto, czy przez referencj
#include "exprops1a.hpp"

// klasa obiektw reprezentujcych dodawanie dwch operandw
template <typename T, typename OP1, typename OP2>
class A_Add {
  private:
    typename A_Traits<OP1>::ExprRef op1;    // pierwszy operand
    typename A_Traits<OP2>::ExprRef op2;    // drugi operand

  public: 
    // konstruktor inicjalizujcy odwoania do operandw
    A_Add (OP1 const& a, OP2 const& b)
     : op1(a), op2(b) {
    }

    // oblicz sum
    T operator[] (size_t idx) const {
        return op1[idx] + op2[idx];
    }

    // size jest rozmiarem maksymalnym
    size_t size() const {
        assert (op1.size()==0 || op2.size()==0
                || op1.size()==op2.size());
        return op1.size()!=0 ? op1.size() : op2.size();
    }
};

// klasa obiektw reprezentujcych mnoenie dwch operandw
template <typename T, typename OP1, typename OP2>
class A_Mult {
  private:
    typename A_Traits<OP1>::ExprRef op1;    // pierswszy operand
    typename A_Traits<OP2>::ExprRef op2;    // drugi operand

  public:
    // konstruktor inicjalizujcy odwoania do operandw
    A_Mult (OP1 const& a, OP2 const& b)
     : op1(a), op2(b) {
    }

    // oblicz iloczyn
    T operator[] (size_t idx) const {
        return op1[idx] * op2[idx];
    }

    // size jest rozmiarem maksymalnym
    size_t size() const {
        assert (op1.size()==0 || op2.size()==0
                || op1.size()==op2.size());
        return op1.size()!=0 ? op1.size() : op2.size();
    }
};
