/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <stddef.h>
#include <cassert>
#include "sarray1.hpp"

template <typename T, typename Rep = SArray<T> >
class Array {
  private:
    Rep expr_rep;   // (dostp do) danych tablicy

  public:
    // utwrz tablic o zadanym rozmiarze pocztkowym
    explicit Array (size_t s)
     : expr_rep(s) {
    }

    // utwrz tablic z reprezentacji wyraenia
    Array (Rep const& rb)
     : expr_rep(rb) {
    }

    // operator przypisania dla typu zgodnego
    Array& operator= (Array const& b) { 
        assert(size()==b.size());
        for (size_t idx = 0; idx<b.size(); ++idx) {
            expr_rep[idx] = b[idx];
        }
        return *this;
    }

    // operator przypisania dla dwch tablic rnych typw
    template<typename T2, typename Rep2>
    Array& operator= (Array<T2, Rep2> const& b) { 
        assert(size()==b.size());
        for (size_t idx = 0; idx<b.size(); ++idx) {
            expr_rep[idx] = b[idx];
        }
        return *this;
    }

    // size jest rozmiarem reprezentowanych danych
    size_t size() const {
        return expr_rep.size();
    }

    // operator indeksowania dla stach i zmiennych
    T operator[] (size_t idx) const {
        assert(idx<size());
        return expr_rep[idx];
    }
    T& operator[] (size_t idx) {
        assert(idx<size());
        return expr_rep[idx];
    }

    // okrel, co tablica reprezentuje
    Rep const& rep() const {
        return expr_rep;
    }
    Rep& rep() {
        return expr_rep;
    }
};
