/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include "statichier.hpp"
#include <vector>

// narysuj dowolny obiekt geometryczny
template <typename GeoObj>
void myDraw (GeoObj const& obj)
{
    obj.draw();    // wywoaj metod draw() odpowiedni dla typu obiektu
}

// oblicz odlego pomidzy rodkami cikoci pomidzy dwoma obiektami GeoObj
template <typename GeoObj1, typename GeoObj2>
Coord distance (GeoObj1 const& x1, GeoObj2 const& x2)
{
    Coord c = x1.center_of_gravity() - x2.center_of_gravity();
    return c.abs();  // wsprzdne zwracane jako wartoci bezwzgldne
}

// narysuj jednorodny zbir obiektw geometrycznych
template <typename GeoObj>
void drawElems (std::vector<GeoObj> const& elems)
{
    for (unsigned i=0; i<elems.size(); ++i) {
        elems[i].draw();    // wywoaj metod draw() odpowiedni dla typu elementu zbioru
    }
}

int main()
{
    Line l;
    Circle c, c1, c2;

    myDraw(l);        // myDraw<Line>(GeoObj&) => Line::draw()
    myDraw(c);        // myDraw<Circle>(GeoObj&) => Circle::draw()

    distance(c1,c2);  // distance<Circle,Circle>(GeoObj1&,GeoObj2&)
    distance(l,c);    // distance<Line,Circle>(GeoObj1&,GeoObj2&)

    // std::vector<GeoObj*> coll;    // BD: nie mona utworzy zbioru jednorodnego
    std::vector<Line> coll;   // DOBRZE: zbir moliwy do utworzenia
    coll.push_back(l);        // wstaw do zbioru obiekt reprezentujcy lini
    drawElems(coll);          // narysuj linie wchodzce w skad zbioru
}
