/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <iostream>
#include <algorithm>
#include "tracer.hpp"

int main()
{
    // przygotuj dane testowe:
    SortTracer input[] = { 7, 3, 5, 6, 4, 2, 0, 1, 9, 8 };

    // wywietl dane testowe:
    for (int i=0; i<10; ++i) {
        std::cerr << input[i].val() << ' ';
    }
    std::cerr << std::endl;

    // zapamitaj warunki pocztkowe:
    long created_at_start = SortTracer::creations();
    long max_live_at_start = SortTracer::max_live();
    long assigned_at_start = SortTracer::assignments();
    long compared_at_start = SortTracer::comparisons();

    // wykonaj algorytm:
    std::cerr << "---[ Start std::sort() ]--------------------\n";
    std::sort<>(&input[0], &input[9]+1);
    std::cerr << "---[ Stop std::sort() ]----------------------\n";

    // sprawd wynik:
    for (int i=0; i<10; ++i) {
        std::cerr << input[i].val() << ' ';
    }
    std::cerr << "\n\n";

    // raport kocowy:
    std::cerr << "std::sort() dla  10 obiektw SortTracer"
              << " wykonany przez:\n "
              << SortTracer::creations() - created_at_start
              << " tropicieli tymczasowych\n "
              << "do  "
              << SortTracer::max_live()
              << " tropicieli jednoczenie (poprzednio " 
              << max_live_at_start << ")\n "
              << SortTracer::assignments() - assigned_at_start
              << " przypisa\n "
              << SortTracer::comparisons() - compared_at_start
              << " porwna\n\n";
}
