/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <iostream>
#include <string>
#include <cstdlib>
#include "stack5.hpp"

int main()
{
    try {
        Stack<int>   intStack;       // stos elementw typu int
        Stack<float> floatStack;     // stos elementw typu float

        // manipuluj stosem elementw int
        intStack.push(42);
        intStack.push(7);

        // manipuluj stosem elementw float
        floatStack.push(7.7);

        // przypisz stosy rnych typw
        floatStack = intStack;

        // wwietl zawarto stosu elementw typu float
        std::cout << floatStack.top() << std::endl;
        floatStack.pop();
        std::cout << floatStack.top() << std::endl;
        floatStack.pop();
        std::cout << floatStack.top() << std::endl;
        floatStack.pop();
    }
    catch (std::exception const& ex) {
        std::cerr << "Wyjtek: " << ex.what() << std::endl;
        return EXIT_FAILURE;  // opu program zwracajc kod bdu
    }
}
