/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
template <typename T>
class Stack {
  private:
    std::deque<T> elems;   // elementy

  public:
    void push(T const&);   // wstaw element na szczyt stosu
    void pop();            // usu element ze szczytu stosu
    T top() const;         // zwr szczytowy element stosu
    bool empty() const {   // czy stos jest pusty?
        return elems.empty();
    }

    // przypisanie stosu elementw typu T2
    template <typename T2>
    Stack<T>& operator= (Stack<T2> const&);
};
