/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#ifndef TYPEOP_HPP
#define TYPEOP_HPP

// szablon podstawowy
/**********************************
 * z pliku typeop1.hpp:
 **********************************/
template <typename T>
class TypeOp {            // szablon podstawowy
  public:
    typedef T         ArgT;
    typedef T         BareT;
    typedef T const   ConstT;
    typedef T &       RefT;
    typedef T &       RefBareT;
    typedef T const & RefConstT;
};
/**** koniec pliku typeop1.hpp ****/

// specjalizacja czciowa dla typw const
/**********************************
 * z pliku typeop2.hpp:
 **********************************/
template <typename T>
class TypeOp <T const> {  // specjalizacja czciowa dla typw const
  public:
    typedef T const   ArgT;
    typedef T         BareT;
    typedef T const   ConstT;
    typedef T const & RefT;
    typedef T &       RefBareT;
    typedef T const & RefConstT;
};
/**** koniec pliku typeop2.hpp ****/

// specjalizacja czciowa dla referencji
/**********************************
 * z pliku typeop3.hpp:
 **********************************/
template <typename T>
class TypeOp <T&> {       // specjalizacja czciowa dla referencji
  public:
    typedef T &                         ArgT;
    typedef typename TypeOp<T>::BareT   BareT;
    typedef T const                     ConstT;
    typedef T &                         RefT;
    typedef typename TypeOp<T>::BareT & RefBareT;
    typedef T const &                   RefConstT;
};
/**** koniec pliku typeop3.hpp ****/

// pena specjalizacja dla typw void
/**********************************
 * z pliku typeop4.hpp:
 **********************************/
template<>
class TypeOp <void> {     // pena specjalizacja dla typw void
  public:
    typedef void       ArgT;
    typedef void       BareT;
    typedef void const ConstT;
    typedef void       RefT;
    typedef void       RefBareT;
    typedef void       RefConstT;
};
/**** koniec pliku typeop4.hpp ****/

#endif // TYPEOP_HPP
