/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
// szablon podstawowy dla typu n-tego pola duetu T
template <int N, typename T>
class DuoT {
  public:
    typedef void ResultT;    // w przypadku oglnym typ wyniku to void
};

// specjalizacja dla pierwszego pola duetu
template <typename A, typename B>
class DuoT<1, Duo<A,B> > {
  public:
    typedef A ResultT;
};

// specjalizacja dla drugiego pola duetu
template <typename A, typename B>
class DuoT<2, Duo<A,B> > {
  public:
    typedef B ResultT;
};

// specjalizacja dla n-tego pola duetu rekurencyjnego
template <int N, typename A, typename B, typename C>
class DuoT<N, Duo<A, Duo<B,C> > > {
  public:
    typedef typename DuoT<N-1, Duo<B,C> >::ResultT ResultT;
};

// specjalizacja dla pierwszego pola duetu rekurencyjnego
template <typename A, typename B, typename C>
class DuoT<1, Duo<A, Duo<B,C> > > {
  public:
    typedef A ResultT;
};

// specjalizacja dla drugiego pola duetu rekurencyjnego
template <typename A, typename B, typename C>
class DuoT<2, Duo<A, Duo<B,C> > > {
  public:
    typedef B ResultT;
};
