/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#ifndef TRULE_HPP
#define TRULE_HPP

template <typename T>
class Holder;

template <typename T>
class Trule {
  private:
    T* ptr;    // obiekt wskazywany przez dorczyciela (jeeli takowy istnieje)

  public:
    // konstruktor gwarantujcy wykorzystanie dorczyciela wycznie jako typu zwracanego
    // do przekazywania obiektu kontrolowanego pomidzy okazicialami
    Trule (Holder<T>& h) {
        ptr = h.get();
        h.release();
    }

    // konstruktor kopiujcy
    Trule (Trule<T> const& t) {
        ptr = t.ptr;
        const_cast<Trule<T>&>(t).ptr = 0;
    }

    // destruktor
    ~Trule() { 
        delete ptr; 
    }

  private:
    Trule(Trule<T>&);                // niezalecane uycie dorczycieli bdcych l-wartociami
    Trule<T>& operator= (Trule<T>&); // niezalecany operator przypisania z kopiowaniem
    friend class Holder<T>;
};

#endif // TRULE_HPP
