/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include "holder.hpp"

class RefMembers {
  private:
    Holder<MemType> ptr1;       // skadowe wskazywane
    Holder<MemType> ptr2;
  public:
    // konstruktor domylny
    // - uniemoliwa wyciek zasobw
    RefMembers ()
     : ptr1(new MemType), ptr2(new MemType) {
    }

    // konstruktor kopiujcy
    // - uniemoliwia wyciek zasobw
    RefMembers (RefMembers const& x)
     : ptr1(new MemType(*x.ptr1)), ptr2(new MemType(*x.ptr2)) {
    }

    // operator przypisania
    const RefMembers& operator= (RefMembers const& x) {
       *ptr1 = *x.ptr1;
       *ptr2 = *x.ptr2;
       return *this;
    }

    // destruktor nie jest konieczny
    // (konstruktor domylny umoliwia zwolnienie obiektw wskazywanych przez obiekty okaziciela)
    //...
};

