/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
template<typename ObjectT,        // klasa zawierajca licznik
         typename CountT,         // typ licznika
         CountT ObjectT::*CountP> // pooenie licznika wewntrz klasy
class MemberReferenceCount
{
  public:
    // domylny konstruktor i destruktor nie wymagaj modyfikacji

    // inicjalizacja licznika do wartoci 1:
    void init (ObjectT* object) {
        object->*CountP = 1;
    }

    // zniszczenie licznika nie wymaga podejmowania adnych czynnoci:
    void dispose (ObjectT*) {
    }

    // zwikszenie licznika:
    void increment (ObjectT* object) {
        ++object->*CountP;
    }
    
    // zmniejszenie licznika:
    void decrement (ObjectT* object) {
        --object->*CountP;
    }

    // porwnanie licznika z zerem:
    template<typename T> bool is_zero (ObjectT* object) {
        return object->*CountP == 0;
    }
};
