/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#ifndef HOLDER_HPP
#define HOLDER_HPP

#include "trule.hpp"

template <typename T>
class Holder {
  private:
    T* ptr;    // odwoanie do przechowywanego obiektu (jeli takowy istnieje)

  public:
    // konstruktor domylny: obiekt posiadacza nic nie wskazuje
    Holder() : ptr(0) {
    }

    // konstruktor przyjmujcy wskanik: oiekt posiadacza bdzie wskazywa adres wskazywany przez wskanik
    explicit Holder (T* p) : ptr(p) {
    }

    // destruktor: zwalnia obiekt wskazywany (o ile takowy istnieje)
    ~Holder() { 
        delete ptr;
    }

    // przypisanie nowego wskanika
    Holder<T>& operator= (T* p) {
        delete ptr;
        ptr = p;
        return *this;
    }

    // operatory wskanikowe
    T& operator* () const { 
        return *ptr;
    }

    T* operator-> () const { 
        return ptr; 
    }

    // zwr obiekt wskazywany (jeeli takowy istnieje)
    T* get() const {
        return ptr;
    }

    // zwolnij prawo wasnoci do obiektu wskazywanego
    void release() {
        ptr = 0;
    }

    // wymie prawo wasnoic z innym obiektem posiadacza
    void exchange_with (Holder<T>& h) {
        swap(ptr,h.ptr);
    }

    // wymie prawo wasnoic z wskanikiem
    void exchange_with(T*& p) {
        swap(ptr,p);
    }

  private:
    // bez kopiowania i przypisywania z kopiowaniem
    Holder (Holder<T> const&);
    Holder<T>& operator= (Holder<T> const&);

  public:
    Holder (Trule<T> const& t) {
        ptr = t.ptr;
        const_cast<Trule<T>&>(t).ptr = 0;
    }

    Holder<T>& operator= (Trule<T> const& t) {
        delete ptr;
        ptr = t.ptr;
        const_cast<Trule<T>&>(t).ptr = 0;
        return *this;
    }
};

#endif // HOLDER_HPP
