/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
template <typename T>
class Holder {
  private:
    T* ptr;    // wskanik do obiektu wskazywanego (jeeli takowy istnieje)

  public:
    // konstruktor domylny: okaziciel nie wskazuje adnego obiektu
    Holder() : ptr(0) {
    }

    // konstruktor przyjmujcy wskanik: okaziciel wskazuje do obiektu wskazywanego przez argument konstruktora
    explicit Holder (T* p) : ptr(p) {
    }

    // destruktor: zwalnia obiekt wskazywany (jeeli takowy istnieje)
    ~Holder() { 
        delete ptr;
    }

    // przypisanie nowego wskanika
    Holder<T>& operator= (T* p) {
        delete ptr;
        ptr = p;
        return *this;
    }

    // operatory wyuskania
    T& operator* () const { 
        return *ptr;
    }

    T* operator-> () const { 
        return ptr; 
    }

    // pobierz obiekt wskazywany (jeeli takowy istnieje)
    T* get() const {
        return ptr;
    }

    // zwolnij prawo wasnoci do wskazywanego obiektu
    void release() {
        ptr = 0;
    }

    // wymie prawo wasnoci z innym okazicielem
    void exchange_with (Holder<T>& h) {
        swap(ptr,h.ptr);
    }

    // wymie prawo wasnoic z innym wskanikiem
    void exchange_with (T*& p) {
        swap(ptr,p);
    }

  private:
    // kopiowanie i przypisanie z kopiowaniem jest niedozwolone
    Holder (Holder<T> const&);
    Holder<T>& operator= (Holder<T> const&);
};
