/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <vector>
#include <iostream>
#include <cstdlib>

// koperta dla wskanikw do funkcji
template<int (*FP)()>
class FunctionReturningIntWrapper {
  public:
    int operator() () {
        return FP();
    }
};

// przykadowa funkcja przeznaczona do kopertowania
int random_int()
{
    return std::rand();  // wywoanie funkcji standardowej jzyka C
}

// klient korzystajcy z typu obiektu funkcyjnego type w parametrze szablonu
template <typename FO>
void initialize (std::vector<int>& coll)
{
    FO fo;  // utworzenie obiektu funkcyjnego
    for (std::vector<int>::size_type i=0; i<coll.size(); ++i) {
        coll[i] = fo();  // wywoanie funkcji na rzecz obiektu funkcyjnego
    }
}

int main()
{
    // utworzenie wektora 10 elementw
    std::vector<int> v(10);

    // (ponowna inicjalizacja wartoci za pomoc funkcji kopertowanej
    initialize<FunctionReturningIntWrapper<random_int> >(v);

    // wydruk elementw wektora
    for (std::vector<int>::size_type i=0; i<v.size(); ++i) {
        std::cout << "coll[" << i << "]: " << v[i] << std::endl;
    }
}
