/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <iostream>
#include <string>
#include <typeinfo>
#include "funcptr.hpp"

double seven() 
{
    return 7.0;
}

std::string more() 
{
    return std::string("wicej");
}

template <typename FunctorT>
void demo (FunctorT func) 
{
    std::cout << "Funktor zwraca typ "
              << typeid(typename FunctorT::ReturnT).name() << '\n'
              << "Funktor zwraca warto "
              << func() << '\n';
}

int main() 
{
    demo(func_ptr(seven));
    demo(func_ptr(more));
}
