/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <iostream>

// klasa obiektw funkcyjnych zwracajcych warto sta
class ConstantIntFunctor {
  private:
    int value;    // warto zwracana w ''wywoaniu funkcji''
  public:
    // konstruktor: inicjalizacja wartoci zwracanej
    ConstantIntFunctor (int c) : value(c) {
    }

    // ''wywoanie funkcji''
    int operator() () const { 
        return value;
    }
};

// funkcja kliencka korzystajca z obiektu funkcyjnego
void client (ConstantIntFunctor const& cif)
{
    std::cout << "wywoanie zwrotne funktora dao " << cif() << '\n';
}

int main() 
{
    ConstantIntFunctor seven(7);
    ConstantIntFunctor fortytwo(42);
    client(seven);
    client(fortytwo);
}
