/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <new>
#include <cassert>
#include <stddef.h>
#include "rparam.hpp"

// szablon podstawowy
template<typename T, bool Bitwise>
class BitOrClassCSM;

// specjalizacja czciowa dla bezpiecznego kopiowania obiektw
template<typename T>
class BitOrClassCSM<T, false> {
  public:
    static void copy (typename RParam<T>::ResultT src, T* dst) {
        // kopiuj element do innego elementu
        *dst = src;
    }

    static void copy_n (T const* src, T* dst, size_t n) {
        // kopiuj n elementw do n innych elementw
        for (size_t k = 0; k<n; ++k) {
            dst[k] = src[k];
        }
    }

    static void copy_init (typename RParam<T>::ResultT src,
                           void* dst) {
        // kopiuj element do obszaru niezainicjalizowanego
        ::new(dst) T(src);
    }

    static void copy_init_n (T const* src, void* dst, size_t n) {
        // kopiuj n elementw do obszaru niezainicjalizowanego
        for (size_t k = 0; k<n; ++k) {
            ::new((void*)((char*)dst+k)) T(src[k]);
        }
    }

    static void swap (T* a, T* b) {
        // wymie dwa elementy
        T tmp(*a);
        *a = *b;
        *b = tmp;
    }

    static void swap_n (T* a, T* b, size_t n) {
        // wymie n elementw
        for (size_t k = 0; k<n; ++k) {
            T tmp(a[k]);
            a[k] = b[k];
            b[k] = tmp;
        }
    }

    static void move (T* src, T* dst) {
        // przenie element do innego elementu
        assert(src != dst);
        *dst = *src;
        src->~T();
    }

    static void move_n (T* src, T* dst, size_t n) {
        // przenie n elementw do n innych elementw
        assert(src != dst);
        for (size_t k = 0; k<n; ++k) {
            dst[k] = src[k];
            src[k].~T();
        }
    }

    static void move_init (T* src, void* dst) {
        // przenie element do obszaru niezainicjalizowanego
        assert(src != dst);
        ::new(dst) T(*src);
        src->~T();
    }

    static void move_init_n (T const* src, void* dst, size_t n) {
        // przenie n elementw do obszaru niezainicjalizowanego
        assert(src != dst);
        for (size_t k = 0; k<n; ++k) {
            ::new((void*)((char*)dst+k)) T(src[k]);
            src[k].~T();
        }
    }
};
