/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include "accum8.hpp"
#include <iostream>

template<typename T1, typename T2>
class MultPolicy {
  public:
    static void accumulate (T1& total, T2 const& value) {
        total *= value;
    }
};

int main()
{
    // utw tablic piciu liczb cakowitych
    int num[] = { 1, 2, 3, 4, 5 };

    // wywietl warto redni liczb
    std::cout << "warto rednia liczb cakowitych wynosi "
              << Accum<int>::accum(&num[0], &num[5]) / 5
              << '\n';

    // wywietl iloczyn liczb
    std::cout << "iloczyn liczb cakowitych wynosi "
              << Accum<int,MultPolicy>::accum(&num[0], &num[5])
              << '\n';

    // utwrz tablic znakw
    char name[] = "szablony";
    int length = sizeof(name)-1;

    // (sprbuj) wywietl warto redni znakw
    std::cout << "warto rednia ze znakw w napisie \""
              << name << "\" wynosi "
              << Accum<char>::accum(&name[0], &name[length]) / length
              << '\n';
}
