/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#ifndef ACCUM_HPP
#define ACCUM_HPP

#include "accumtraits4.hpp"
#include "sumpolicy1.hpp"

template <typename T,
          typename Policy = SumPolicy,
          typename Traits = AccumulationTraits<T> >
class Accum {
  public:
    typedef typename Traits::AccT AccT;
    static AccT accum (T const* beg, T const* end) {
        AccT total = Traits::zero();
        while (beg != end) {
            Policy::accumulate(total, *beg);
            ++beg;
        }
        return total;
    }
};

#endif // ACCUM_HPP
