/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
// klasa obiektw reprezentujcych w wyraeniu wartoci skalarne
template <typename T>
class A_Scalar {
  private:
    T const& s;  // warto skalara

  public:
    // konstruktor inicjalizujcy warto
    A_Scalar (T const& v)
     : s(v) {
    }

    // dla operacji indeksowania skalar jest wartoci identyczn dla kadego elementu
    T operator[] (size_t) const {
        return s;
    }

    // skalary maj rozmiar rwny 0
    size_t size() const {
        return 0;
    };
};
