/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include "dynahier.hpp"
#include <vector>

// rysuj dowolny obiekt GeoObj
void myDraw (GeoObj const& obj)
{
    obj.draw();            // wywoaj metod draw() odpowiedni dla typu obiektu
}

// oblicz odlego pomidzy rodkami cikoci dwch obiektw GeoObj
Coord distance (GeoObj const& x1, GeoObj const& x2)
{
    Coord c = x1.center_of_gravity() - x2.center_of_gravity();
    return c.abs();        // zwr wsprzdne jako wartoci bezwzgldne
}

// rysuj jednorodny zbir obiektw GeoObj
void drawElems (std::vector<GeoObj*> const& elems)
{
    for (unsigned i=0; i<elems.size(); ++i) {
        elems[i]->draw();  // wywoaj metod draw() odpowiedni dla typu elementu zbioru
    }
}

int main()
{
    Line l;
    Circle c, c1, c2;

    myDraw(l);            // myDraw(GeoObj&) => Line::draw()
    myDraw(c);            // myDraw(GeoObj&) => Circle::draw()

    distance(c1,c2);      // distance(GeoObj&,GeoObj&)
    distance(l,c);        // distance(GeoObj&,GeoObj&)

    std::vector<GeoObj*> coll;  // jednorodny zbir obiektw
    coll.push_back(&l);         // wstaw do zbioru lini
    coll.push_back(&c);         // wstawdo zbioru okrg
    drawElems(coll);            // rysuj rne rodzaje obiektwGeoObjs
}
