/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <iostream>

class SortTracer {
  private:
    int value;                // warto typu int do posortowania
    int generation;           // generacja tropiciela
    static long n_created;    // liczba wywoa konstruktora
    static long n_destroyed;  // liczba wywoa destruktora
    static long n_assigned;   // liczba operacji przypisania
    static long n_compared;   // liczba operacji porwnania
    static long n_max_live;   // maksymalna liczba istniejcych obiektw

    // przelicz maksymaln liczb istniejcych obiektw
    static void update_max_live() {
        if (n_created-n_destroyed > n_max_live) {
            n_max_live = n_created-n_destroyed;
        }
    }

  public:
    static long creations() { 
        return n_created; 
    }
    static long destructions() { 
        return n_destroyed; 
    }
    static long assignments() { 
        return n_assigned; 
    }
    static long comparisons() { 
        return n_compared; 
    }
    static long max_live() { 
        return n_max_live; 
    }

  public:
    // konstruktor
    SortTracer (int v = 0) : value(v), generation(1) {
        ++n_created;
        update_max_live();
        std::cerr << "SortTracer #" << n_created
                  << ", utworzono generacj " << generation
                  << " (cznie: " << n_created - n_destroyed
                  << ")\n";
    }
   
    // konstruktor kopiujcy
    SortTracer (SortTracer const& b) 
     : value(b.value), generation(b.generation+1) {
        ++n_created;
        update_max_live();
        std::cerr << "SortTracer #" << n_created
                  << ", skopiowany jako generacja " << generation
                  << " (cznie: " << n_created - n_destroyed
                  << ")\n";
    }

    // destruktor
    ~SortTracer() {
        ++n_destroyed;
        update_max_live();
        std::cerr << "SortTracer generation " << generation
                  << " zniszczony (cznie: " 
                  << n_created - n_destroyed << ")\n";
    }

    // przypisanie
    SortTracer& operator= (SortTracer const& b) {
        ++n_assigned;
        std::cerr << "SortTracer assignment #" << n_assigned 
                  << " (generacja " << generation
                  << " = " << b.generation 
                  << ")\n";
        value = b.value;
        return *this;
    }

    // porwnanie
    friend bool operator < (SortTracer const& a, 
                            SortTracer const& b) {
        ++n_compared;
        std::cerr << "SortTracer comparison #" << n_compared 
                  << " (generacja " << a.generation
                  << " < " << b.generation 
                  << ")\n";
        return a.value < b.value;
    }

    int val() const { 
        return value;
    }
};
