/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <stdexcept>

template <typename T, int MAXSIZE>
class Stack {
  private:
    T elems[MAXSIZE];        // elementy
    int numElems;            // aktualna liczba elementw stosu

  public:
    Stack();                  // konstruktor
    void push(T const&);      // wstaw element na szczyt stosu
    void pop();               // usu element ze szczytu stosu
    T top() const;            // zwr szczytowy element stosu
    bool empty() const {      // czy stos jest pusty?
        return numElems == 0;
    }
    bool full() const {       // czy stos jest peny?
        return numElems == MAXSIZE;
    }
};

// konstruktor
template <typename T, int MAXSIZE>
Stack<T,MAXSIZE>::Stack ()
  : numElems(0)               // zaczynamy od stosu pustego
{
    // nie ma nic wicej do roboty
}

template <typename T, int MAXSIZE>
void Stack<T,MAXSIZE>::push (T const& elem)
{
    if (numElems == MAXSIZE) {
        throw std::out_of_range("Stack<>::push(): stos jest peen");
    }
    elems[numElems] = elem;   // docz element
    ++numElems;               // zwiksz liczb elementw
}

template<typename T, int MAXSIZE>
void Stack<T,MAXSIZE>::pop ()
{
    if (numElems <= 0) {
        throw std::out_of_range("Stack<>::pop(): stos jest pusty");
    }
    --numElems;               // zmniejsz liczb elementw
}

template <typename T, int MAXSIZE>
T Stack<T,MAXSIZE>::top () const
{
    if (numElems <= 0) {
        throw std::out_of_range("Stack<>::top(): stos jest pusty");
    }
    return elems[numElems-1];  // zwr ostatni element
}
