/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <iostream>
#include <string>
#include <cstdlib>
#include "stack1.hpp"

int main()
{
    try {
        Stack<int>         intStack;       // stos elementw typu int
        Stack<std::string> stringStack;    // stos elementw typu std::string

        // manipuluj stosem elementw typu int
        intStack.push(7);
        std::cout << intStack.top() << std::endl;

        // manipuluj stosem elementw typu std::string
        stringStack.push("Ahoj");
        std::cout << stringStack.top() << std::endl; 
        stringStack.pop();
        stringStack.pop();
    }
    catch (std::exception const& ex) {
        std::cerr << "Wyjtek: " << ex.what() << std::endl;
        return EXIT_FAILURE;  // op program zwracajc kod bdu
    }
}
