/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
// maksimum z dwch wartoci typu int
inline int const& max (int const& a, int const& b) 
{
    return  a < b ? b : a;
}

// maksimum z dwch wartoci dowolnego typu
template <typename T>
inline T const& max (T const& a, T const& b)
{
    return  a < b ? b : a;
}

// maksimum z trzech wartoci dowolnego typu
template <typename T>
inline T const& max (T const& a, T const& b, T const& c)
{
    return max (max(a,b), c);
}

int main()
{
    ::max(7, 42, 68);      // wywoanie szablonu z przekazaniem trzech argumentw
    ::max(7.0, 42.0);      // wywoanie szablonu max<double> (dedukcja typu argumentw)
    ::max('a', 'b');       // wywoanie szablonu max<double> (dedukcja typu argumentw)
    ::max(7, 42);          // wywoanie funkcji zwykej dla dwch argumentw int
    ::max<>(7, 42);        // wywoanie szablonu max<int> (dedukcja typu argumentw)
    ::max<double>(7, 42);  // wywoanie szablonu max<double> (bez dedukcji typu)
    ::max('a', 42.7);      // wywoanie funkcji zwykej dla dwch argumentw int
}
