/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include "addval.hpp"

void call_addValue()
{
    addValue<int,5>(42);
}

template <typename IT, typename OP>
void transform (IT beg, IT end, IT to, OP op)
{
    while (beg != end) {
        *to++ = op(*beg++);
    }
}

int main()
{
    call_addValue();

    int m[] = { 1, 2, 3, 4, 5, 6 };

    transform (m, m+6, 
               m,
#ifndef CORE_ISSUE_115_SOLVED
               (int(*)(int const&))    // konieczne jest rzutowanie
#endif
               addValue<int,5>);
}

