/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include "duo1.hpp"
#include "duo2.hpp"
#include "duo3.hpp"
#include "duo4.hpp"
#include "duo5.hpp"
#include "duo6.hpp"
#include "typeop.hpp"

// typ reprezentujcy niewykorzystywane parametry
class NullT {
};

// w oglnoci Tuple<> jest pochodn szablonu Duo<> z jednym lub wicej argumentw NullT
template <typename P1,
          typename P2 = NullT,
          typename P3 = NullT,
          typename P4 = NullT,
          typename P5 = NullT>
class Tuple
 : public Duo<P1, typename Tuple<P2,P3,P4,P5,NullT>::BaseT> {
  public:
    typedef Duo<P1, typename Tuple<P2,P3,P4,P5,NullT>::BaseT>
            BaseT;

    // konstrukotry:
    Tuple() {}
    Tuple(typename TypeOp<P1>::RefConstT a1,
          typename TypeOp<P2>::RefConstT a2,
          typename TypeOp<P3>::RefConstT a3 = NullT(),
          typename TypeOp<P4>::RefConstT a4 = NullT(),
          typename TypeOp<P5>::RefConstT a5 = NullT())
     : BaseT(a1, Tuple<P2,P3,P4,P5,NullT>(a2,a3,a4,a5)) {
    }
};

// specjalizacja koczca rekurencj pochodnej
template <typename P1, typename P2>
class Tuple<P1,P2,NullT,NullT,NullT> : public Duo<P1,P2> {
  public:
    typedef Duo<P1,P2> BaseT;
    Tuple() {}
    Tuple(typename TypeOp<P1>::RefConstT a1,
          typename TypeOp<P2>::RefConstT a2,
          typename TypeOp<NullT>::RefConstT = NullT(),
          typename TypeOp<NullT>::RefConstT = NullT(),
          typename TypeOp<NullT>::RefConstT = NullT())
     : BaseT(a1, a2) {
    }
};

// specjalizacja dla krotek jednoelementowych
template <typename P1>
class Tuple<P1,NullT,NullT,NullT,NullT> : public Duo<P1,void> {
  public:
    typedef Duo<P1,void> BaseT;
    Tuple() {}
    Tuple(typename TypeOp<P1>::RefConstT a1,
          typename TypeOp<NullT>::RefConstT = NullT(),
          typename TypeOp<NullT>::RefConstT = NullT(),
          typename TypeOp<NullT>::RefConstT = NullT(),
          typename TypeOp<NullT>::RefConstT = NullT())
     : BaseT(a1) {
    }
};

// wygodna funkcja dla jednego argumentu
template <typename T1>
inline
Tuple<T1> make_tuple(T1 const &a1)
{
    return Tuple<T1>(a1);
}

// wygodna funkcja dla dwch argumentw
template <typename T1, typename T2>
inline
Tuple<T1,T2> make_tuple(T1 const &a1, T2 const &a2)
{
    return Tuple<T1,T2>(a1,a2);
}

// wygodna funkcja dla trzech argumentw
template <typename T1, typename T2, typename T3>
inline
Tuple<T1,T2,T3> make_tuple(T1 const &a1, T2 const &a2,
                           T3 const &a3)
{
    return Tuple<T1,T2,T3>(a1,a2,a3);
}

// wygodna funkcja dla czterech argumentw
template <typename T1, typename T2, typename T3, typename T4>
inline
Tuple<T1,T2,T3,T4> make_tuple(T1 const &a1, T2 const &a2, 
                              T3 const &a3, T4 const &a4)
{
    return Tuple<T1,T2,T3,T4>(a1,a2,a3,a4);
}

// wygodna funkcja dla piciu argumentw
template <typename T1, typename T2, typename T3,
          typename T4, typename T5>
inline
Tuple<T1,T2,T3,T4,T5> make_tuple(T1 const &a1, T2 const &a2,
                                 T3 const &a3, T4 const &a4,
                                 T5 const &a5)
{
    return Tuple<T1,T2,T3,T4,T5>(a1,a2,a3,a4,a5);
}
