/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include "typeop.hpp"

// szablon podstawowy dla wartoci N-tego pola duetu T
template <int N, typename T>
class DuoValue {
  public:
    static void get(T&) {        // w przypadku oglnym pole nie ma wartoci
    }
    static void get(T const&) {
    }
};

// specjalizacja dla pierwszego pola duetu zwykego
template <typename A, typename B>
class DuoValue<1, Duo<A, B> > {
  public:
    static A& get(Duo<A, B> &d) { 
        return d.v1();
    }
    static A const& get(Duo<A, B> const &d) {
        return d.v1();
    }
};

// specjalizacja dla drugiego pola duetu zwykego
template <typename A, typename B>
class DuoValue<2, Duo<A, B> > {
  public:
    static B& get(Duo<A, B> &d) { 
        return d.v2(); 
    }
    static B const& get(Duo<A, B> const &d) { 
        return d.v2();
    }
};

// specjalizacja dla N-tego pola duetu rekurencyjnego
template <int N, typename A, typename B, typename C>
class DuoValue<N, Duo<A, Duo<B,C> > > {
  public:
    static
    typename TypeOp<typename DuoT<N-1, Duo<B,C> >::ResultT>::RefT
    get(Duo<A, Duo<B,C> > &d) {
        return DuoValue<N-1, Duo<B,C> >::get(d.v2());
    }

    static typename TypeOp<typename DuoT<N-1, Duo<B,C>
                          >::ResultT>::RefConstT
    get(Duo<A, Duo<B,C> > const &d) {
        return DuoValue<N-1, Duo<B,C> >::get(d.v2());
    }
};

// specjalizacja dla pierwszego pola duetu rekurencyjnego
template <typename A, typename B, typename C>
class DuoValue<1, Duo<A, Duo<B,C> > > {
  public:
    static A& get(Duo<A, Duo<B,C> > &d) { 
        return d.v1(); 
    }
    static A const& get(Duo<A, Duo<B,C> > const &d) { 
        return d.v1(); 
    }
};

// specjalizacja dla drugiego pola duetu rekurencyjnego
template <typename A, typename B, typename C>
class DuoValue<2, Duo<A, Duo<B,C> > > {
  public:
    static B& get(Duo<A, Duo<B,C> > &d) { 
        return d.v2().v1(); 
    }
    static B const& get(Duo<A, Duo<B,C> > const &d) {
        return d.v2().v1();
    }
};
