/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <stddef.h>  // definiuje typ size_t
#include "allocator.hpp"

class SimpleReferenceCount {
  private:
    size_t* counter;    // alokowany licznik
  public:
    SimpleReferenceCount () {
        counter = NULL;
    }

    // domylny konstruktor kopiujcy oraz operator przypisania z kopiowaniem
    // s w porzdku - po prostu kopiuj wspuytkowany licznik

  public:
    // alokowanie licznika i JEGO inicjalizacja do wartoci 1:
    template<typename T> void init (T*) {
        counter = alloc_counter();
        *counter = 1;
    }

    // zniszczenie licznika:
    template<typename T> void dispose (T*) {
        dealloc_counter(counter);
    }

    // zwikszenie wartoci licznika:
    template<typename T> void increment (T*) {
        ++*counter;
    }
    
    // zmniejszenie wartoci licznika:
    template<typename T> void decrement (T*) {
        --*counter;
    }

    // porwnanie licznika z zerem:
    template<typename T> bool is_zero (T*) {
        return *counter == 0;
    }
};
