/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
class RefMembers {
  private:
    MemType* ptr1;       // skadowe wskazywane
    MemType* ptr2;
  public:
    // konstruktor domylny
    // - spowoduje wyciek zasobw w przypadku niepowodzenia wykonania drugiego z operatorw new
    RefMembers ()
     : ptr1(new MemType), ptr2(new MemType) {
    }

    // konstruktor kopiujcy
    // - moe spowodowa wyciek zasobw jeeli wyjtek zdarzy si w drugiej operacji przydziau
    RefMembers (RefMembers const& x)
     : ptr1(new MemType(*x.ptr1)), ptr2(new MemType(*x.ptr2)) {
    }

    // operator przypisania
    const RefMembers& operator= (RefMembers const& x) {
       *ptr1 = *x.ptr1;
       *ptr2 = *x.ptr2;
       return *this;
    }

    ~RefMembers () {
        delete ptr1;
        delete ptr2;
    }
    //...
};
