/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
// szablon podstawowy obsuguje maksymaln liczb parametrw:
template<typename RT, typename P1 = void, 
                      typename P2 = void,
                      typename P3 = void>
class FunctionPtrT {
  public:
    enum { NumParams = 3 };
    typedef RT (*Type)(P1,P2,P3);
};

// specjalizacja czciowa dla dwch parametrw:
template<typename RT, typename P1,
                      typename P2>
class FunctionPtrT<RT, P1, P2, void> {
  public:
    enum { NumParams = 2 };
    typedef RT (*Type)(P1,P2);
};

// specjalizacja czciowa dla jednego parametru:
template<typename RT, typename P1>
class FunctionPtrT<RT, P1, void, void> {
  public:
    enum { NumParams = 1 };
    typedef RT (*Type)(P1);
};

// specjalizacja czciowa dla funktorw bezparametrowych:
template<typename RT>
class FunctionPtrT<RT, void, void, void> {
  public:
    enum { NumParams = 0 };
    typedef RT (*Type)();
};
