/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <iostream>
#include <typeinfo>

void foo()
{
    std::cout << "wywoano foo()" << std::endl;
}
     
typedef void FooT();  // Foot jest typem funkcyjnym,
                      // podobnie jak typu identycznego z typem funkcji foo()

int main()
{
    foo();           // wywoanie bezporednie

    // wywietl typy foo i FooT
    std::cout << "Typy foo:  " << typeid(foo).name()
              << '\n';
    std::cout << "Typy Foot: " << typeid(FooT).name()
              << '\n';

    FooT* pf = foo;  // konwersja niejawna (rozmontowanie)
    pf();            // wywoanie porednie przez wskanik
    (*pf)();         // odpowiednik pf()

    // wywietl typ pf
    std::cout << "Typy pf:   " << typeid(pf).name()
              << '\n';

    FooT& rf = foo;  // bez konwersji niejawnej
    rf();            // wywoanie porednie przez referencj

    // wywietl typ rf
    std::cout << "Typy rf:   " << typeid(rf).name()
              << '\n';
}
