/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
template <typename FO1, typename FO2>
class Composer {
  private:
    FO1 fo1;  // pierwszy (wewntrzny) funktor do wywoania
    FO2 fo2;  // drugi (zewntrzny) funktor do wywoania
  public:
    // konstruktor: inicjalizacja obiektw funkcyjnych
    Composer (FO1 f1, FO2 f2)
     : fo1(f1), fo2(f2) {
    }
 
    // ``wywoanie funkcji'': zagniedone wywoania obiektw funkcyjnych
    double operator() (double v) {
        return fo2(fo1(v));
    }
};
