/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <iostream>
#include "math1.hpp"
#include "compose1.hpp"

template<typename FO>
void print_values (FO fo) 
{
    for (int i=-2; i<3; ++i) {
        std::cout << "f(" << i*0.1
                  << ") = " << fo(i*0.1)
                  << "\n";
    }
}

int main()
{
    // wypisz sin(abs(-0.5))
    std::cout << Composer<Abs,Sine>(Abs(),Sine())(0.5) << "\n\n";

    // wypisz abs() pewnej wartoci
    print_values(Abs());
    std::cout << '\n';

    // wypisz sin() pewnej wartoci
    print_values(Sine());
    std::cout << '\n';

    // wypisz sin(abs()) pewnej wartoci
    print_values(Composer<Abs, Sine>(Abs(), Sine()));
    std::cout << '\n';

    // wypisz abs(sin()) pewnej wartoci
    print_values(Composer<Sine, Abs>(Sine(), Abs()));
}
