/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
// wygodna funkcja wizania wskanika funkcji z trzema parametrami
template<int PNum, typename RT, typename P1, typename P2, typename P3>
inline
Binder<FunctionPtr<RT,P1,P2,P3>,
       PNum,
       BoundVal<typename FunctorParam<FunctionPtr<RT,P1,P2,P3>,
                                      PNum
                                     >::Type
               >
      >
bindfp (RT (*fp)(P1,P2,P3),
        typename ForwardParamT<typename FunctorParam<FunctionPtr<RT,P1,P2,P3>,
                                                     PNum
                                                    >::Type  
                              >::Type val)
{
    return Binder<FunctionPtr<RT,P1,P2,P3>, PNum,
                  BoundVal<typename FunctorParam<FunctionPtr<RT,P1,P2,P3>,
                                                             PNum
                                                >::Type>
                          >(func_ptr(fp),
                            BoundVal<typename FunctorParam
                                       <FunctionPtr<RT,P1,P2,P3>,
                                        PNum
                                       >::Type
                                    >(val));
}
