/* Poniszy kod przykadowy zosta zaczerpnity z ksiki
 * "C++ Templates - The Complete Guide" autorstwa
 * Davida Vandevoorde'a i Nicolai'a M. Josuttisa, wydanej
 * w Polsce przez wydawnictwo HELION S.A. w roku 2003
 * (wydanie oryginalne: Addison-Wesley, 2002)
 *
 * (C) Copyright David Vandevoorde i Nicolai M. Josuttis 2002.
 * Kopiowanie, wykorzystanie, modyfikacja, sprzeda i
 * rozpowszechnianie tego oprogramowania jest dozwolone pod
 * warunkiem zachowania niniejszej noty o prawach autorskich
 * w kadej z wykonanych kopii.
 * Oprogramowanie to zostao udostpnione bez adnych jawnych
 * i niejawnych gwarancji; Autorzy nie gwarantuj te poprawnoci
 * dziaania niezalenie od zastosowania.
 */
#include <stddef.h>

template <typename CountedType>
class ObjectCounter {
  private:
    static size_t count;    // licznik istniejcych obiektw

  protected:
    // konstruktor domylny
    ObjectCounter() { 
        ++ObjectCounter<CountedType>::count;
    }

    // konstruktor kopiujcy
    ObjectCounter (ObjectCounter<CountedType> const&) {
        ++ObjectCounter<CountedType>::count; 
    }

    // destruktor
    ~ObjectCounter() { 
        --ObjectCounter<CountedType>::count;
    }

  public:
    // zwr liczb istniejcych obiektw:
    static size_t live() { 
        return ObjectCounter<CountedType>::count; 
    }
};

// inicjalizacja licznika wartoci zero
template <typename CountedType>
size_t ObjectCounter<CountedType>::count = 0;
