#include <iostream.h>

void trace(const char *funcName, void *objAddr)
{
  cout <<  "\t" << objAddr << " " << funcName << "\n";
}

class Top {
  int x;
public: 
  Top & operator=(const Top &);
};

Top & Top::operator=(const Top & rhs)
{
  trace("Top::operator=", this);
  if( this != &rhs )
      x = rhs.x;
  return *this;
}

class Left : public virtual Top {
  int y;
protected:
  void assignLocal(const Left &);
public: 
  Left & operator=(const Left &);
};

void Left::assignLocal(const Left & rhs)
{
  trace("Left::assignLocal", this);
      y = rhs.y;
}

Left & Left::operator=(const Left & rhs)
{
  trace("Left::operator=", this);
  if( this != &rhs ) {
    this->Top::operator=( rhs );
    assignLocal( rhs );
  }
  return *this;
}

class Right : public virtual Top {
  int z;
protected:
  void assignLocal(const Right &);
public: 
  Right & operator=(const Right &);
};

void Right::assignLocal(const Right & rhs)
{
  trace("Right::assignLocal", this);
      z = rhs.z;
}

Right & Right::operator=(const Right & rhs)
{
  trace("Right::operator=", this);
  if( this != &rhs ) {
    this->Top::operator=( rhs );
    assignLocal( rhs );
  }
  return *this;
}

class Bottom : public Left, public Right {
// ...
public:
  Bottom & operator=(const Bottom &);
};

Bottom& Bottom::operator=(const Bottom& rhs)
{
  trace("Bottom::operator=", this);
  if( this != &rhs ) {
    Top::operator=(rhs);
    Left::assignLocal(rhs);
    Right::assignLocal(rhs);
  }
  return *this;
}

int main()
{
  Left L1, L2;
  Right R1, R2; 
  Bottom B1, B2; 

  cout << "Przypisanie obiektw klasy Left \n";
  L1 = L2;
  cout << "Przypisanie obiektw klasy Right \n";
  R1 = R2;
  cout << "Przypisanie obiektw klasy Bottom \n";
  B1 = B2;

  return 0;
}
